package com.saorsa.tm;

import java.io.CharArrayWriter;
import java.io.FileNotFoundException;
import java.util.MissingResourceException;

import org.xml.sax.AttributeList;
import reh.SaxMapper.SaxMapper;
import reh.SaxMapper.TagTracker;

/**
 * This class encapsulates information about the company 
 * for whom the system is working.
 */

public class Company {
  public static void loadFromFile(String aFilename)
    throws FileNotFoundException {
    instance = (Company) (new CompanyLoader().fromXML(aFilename));
  }

  public static Company getInstance() {
    if (instance == null) {
      throw new MissingResourceException(
        "Company is not initialized... no instance loaded yet",
        "Company",
        "");
    }
    return instance;
  }

  public static String fixBackslashNs(String originalString) {
    StringBuffer result = new StringBuffer();
    int start = 0;
    int index = originalString.indexOf("\\n");
    while (index != -1) {
      result.append(originalString.substring(start, index));
      result.append("\n");
      start = index + 2;
      index = originalString.indexOf("\\n", start);
    }
    result.append(originalString.substring(start));
    return result.toString();
  }

  protected Company() {}

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getAddress() {
    return address;
  }

  public void setAddress(String address) {
    this.address = Company.fixBackslashNs(address);
  }

  public String getHst() {
    return hst;
  }

  public void setHst(String hst) {
    this.hst = hst;
  }

  public String getLogo() {
    return logo;
  }

  public void setLogo(String logo) {
    this.logo = logo;
  }

  private String name;
  private String address;
  private String hst;
  private String logo;
  private static Company instance = null;

  private static class CompanyLoader extends SaxMapper {

    Company aCompany;

    public Object getMappedObject() {
      return aCompany;
    }

    public TagTracker createTagTrackerNetwork() {
      TagTracker root = new TagTracker() {};

      TagTracker companyTracker = new TagTracker() {
        public void onStart(String localName, AttributeList atts) {
          aCompany = new Company();
        }
      };
      root.track("/company", companyTracker);

      TagTracker nameTracker = new TagTracker() {
        public void onEnd(String localName, CharArrayWriter contents) {
          aCompany.setName(contents.toString());
        }
      };
      companyTracker.track("name", nameTracker);

      TagTracker addressTracker = new TagTracker() {
        public void onEnd(String localName, CharArrayWriter contents) {
          aCompany.setAddress(contents.toString());
        }
      };
      companyTracker.track("address", addressTracker);

      TagTracker hstTracker = new TagTracker() {
        public void onEnd(String localName, CharArrayWriter contents) {
          aCompany.setHst(contents.toString());
        }
      };
      companyTracker.track("hst", hstTracker);

      TagTracker logoTracker = new TagTracker() {
        public void onEnd(String localName, CharArrayWriter contents) {
          aCompany.setLogo(contents.toString());
        }
      };
      companyTracker.track("logo", logoTracker);

      return root;
    }
  }
}