// Copyright (C) 2001 Saorsa Development Inc.

package com.saorsa.tm.ui;

import java.awt.BorderLayout;
import java.awt.event.*;
import java.io.*;
import java.text.MessageFormat;

import javax.swing.*;

import com.saorsa.tm.*;
import com.saorsa.tm.printing.InvoicePrinter;
import com.saorsa.util.ArgChecker;

public class MainUI extends JFrame {
  private static final String USAGE = "[ -d datadir ] [ -o outputdir ]";
  private static final String SEQUENCE_FILE_NAME = "sequence.xml";
  private static final String PART_FILE_NAME = "part.xml";
  private static final String CUSTOMER_FILE_NAME = "customer.xml";
  private static final String QUOTE_FILE_NAME = "quote.xml";
  private static final String INVOICE_FILE_NAME = "invoice.xml";
  private static final String COMPANY_FILE_NAME = "company.xml";

  public MainUI() {
    initComponents();
    pack();
  }

  private void exitUI() {
    if (customerEd.maybeSaveOutstandingChanges()
      && partEd.maybeSaveOutstandingChanges()
      && quoteEd.maybeSaveOutstandingChanges()
      && invoiceEd.maybeSaveOutstandingChanges()) {
      System.exit(0);
    }
  }

  public void editInvoice(Invoice anInvoice) {
    tabbedPane.setSelectedIndex(3);
    invoiceEd.editInvoice(anInvoice);
  }

  private void initComponents() {
    menuBar = new javax.swing.JMenuBar();
    fileMenu = new javax.swing.JMenu();
    fileMenu.setText("Menu");
    fileMenu.setLabel("File");
    exitMenuItem = new javax.swing.JMenuItem();
    exitMenuItem.setText("Item");
    exitMenuItem.setLabel("Exit");
    exitMenuItem.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent evt) {
        exitUI();
      }
    });
    fileMenu.add(exitMenuItem);
    helpMenu = new javax.swing.JMenu();
    helpMenu.setText("Menu");
    helpMenu.setLabel("Help");
    aboutMenuItem = new javax.swing.JMenuItem();
    aboutMenuItem.setText("Item");
    aboutMenuItem.setLabel("About");
    aboutMenuItem.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(
          null,
          MessageFormat.format(
            "{0}\nTime&Materials System\nCopyright 2001 Saorsa Development Inc.",
            new Object[] { Company.getInstance().getName()}),
          "About Parts&Labour",
          JOptionPane.INFORMATION_MESSAGE);
      }
    });
    helpMenu.add(aboutMenuItem);
    menuBar.add(fileMenu);
    menuBar.add(helpMenu);
    setJMenuBar(menuBar);
    getContentPane().setLayout(new BorderLayout());
    // create tab
    JLabel label;
    tabbedPane = new JTabbedPane();
    getContentPane().add(tabbedPane, BorderLayout.CENTER);
    String name = "Customers";
    customerEd = new CustomerEditor(outputdir);
    tabbedPane.addTab(name, customerEd);
    name = "Parts";
    partEd = new PartEditor(outputdir);
    tabbedPane.addTab(name, partEd);
    name = "Quotes";
    quoteEd = new QuoteEditor(outputdir, this);
    tabbedPane.addTab(name, quoteEd);
    name = "Invoices";
    invoiceEd = new InvoiceEditor(outputdir, this);
    tabbedPane.addTab(name, invoiceEd);

    jLabel1 = new javax.swing.JLabel();
    jLabel1.setText("Status");
    jLabel1.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
    jLabel1.setName("status");
    getContentPane().add(jLabel1, java.awt.BorderLayout.SOUTH);
    setResizable(true);
    setName("Precise Invoicing System");
    addWindowListener(new java.awt.event.WindowAdapter() {
      public void windowClosing(java.awt.event.WindowEvent evt) {
        exitUI();
      }
    });

    PartChooser.initialize(this);
    CustomerChooser.initialize(this);
  }

  private static void initSystem() throws FileNotFoundException, IOException {
    Company.loadFromFile(datadir + COMPANY_FILE_NAME);
    Sequence.setFile(datadir + SEQUENCE_FILE_NAME);
    Customer.setFile(datadir + CUSTOMER_FILE_NAME);
    Part.setFile(datadir + PART_FILE_NAME);
    Quote.setFile(datadir + QUOTE_FILE_NAME);
    Invoice.setFile(datadir + INVOICE_FILE_NAME);
    InvoicePrinter.init();
  }

  public static void main(String[] argv) {
    ArgChecker args = new ArgChecker(USAGE, argv);
    if (!args.isValid()) {
      System.err.println("usage: precise " + USAGE);
      return;
    }
    if (args.switchFound("-d")) {
      datadir = args.paramNamed("datadir");
      if (datadir.charAt(datadir.length() - 1) != File.separatorChar) {
        datadir = datadir + File.separator;
      }
    } else {
      datadir = "";
    }

    if (args.switchFound("-o")) {
      outputdir = args.paramNamed("outputdir");
      if (outputdir.charAt(outputdir.length() - 1) != File.separatorChar) {
        outputdir = outputdir + File.separator;
      }
    } else {
      outputdir = "";
    }

    try {
      initSystem();
    } catch (FileNotFoundException ex) {
      System.err.println("Error opening a file: " + ex.getMessage());
      return;
    } catch (IOException ex) {
      System.err.println("Error loading databases: " + ex.getMessage());
      return;
    }
    new MainUI().show();
  }
  
  private javax.swing.JMenuBar menuBar;
  private javax.swing.JMenu fileMenu;
  private javax.swing.JMenuItem exitMenuItem;
  private javax.swing.JMenu helpMenu;
  private javax.swing.JMenuItem aboutMenuItem;
  private javax.swing.JLabel jLabel1;
  private CustomerEditor customerEd;
  private PartEditor partEd;
  private QuoteEditor quoteEd;
  private InvoiceEditor invoiceEd;
  private JTabbedPane tabbedPane;

  private static String datadir;
  private static String outputdir;
}