// Copyright (C) 2001 Saorsa Development Inc.

package com.saorsa.tm.ui;

import java.util.List;

import javax.swing.table.AbstractTableModel;

import com.saorsa.tm.ChangeTracker;
import com.saorsa.tm.Lineitem;

public class LineitemTableModel extends AbstractTableModel {
  public LineitemTableModel(List allLineitems) {
    super();
    lineitems = allLineitems;
  }

  public void setLineitems(List someLineitems) {
    lineitems = someLineitems;
    fireTableDataChanged();
    ChangeTracker.getTracker("lineitem").reset();
  }

  public String getColumnName(int col) {
    return columnNames[col];
  }

  public Class getColumnClass(int c) {
    return getValueAt(0, c).getClass();
  }

  public boolean isCellEditable(int row, int col) {
    return col > 0;
  }

  public Object getValueAt(int row, int col) {
    Lineitem theLineitem = (Lineitem) lineitems.get(row);
    switch (col) {
      case 0 :
        return theLineitem.getPart().getName();
      case 1 :
        return new Integer(theLineitem.getQuantity());
      default :
        return null;
    }
  }

  public void setValueAt(Object value, int row, int col) {
    Lineitem theLineitem = (Lineitem) lineitems.get(row);
    switch (col) {
      case 0 :
        break;
      case 1 :
        theLineitem.setQuantity(((Integer) value).intValue());
        break;
    }
  }

  public int getColumnCount() {
    return columnNames.length;
  }

  public int getRowCount() {
    return lineitems.size();
  }

  public void rowAdded(int rowNum) {
    fireTableRowsInserted(rowNum, rowNum);
  }

  public void rowRemoved(int rowNum) {
    fireTableRowsDeleted(rowNum, rowNum);
  }

  private List lineitems = null;
  private String[] columnNames = { "Item", "Qty" };

}