// Copyright (C) 2001 Saorsa Development Inc.

package com.saorsa.tm.ui;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.*;

import com.saorsa.tm.ChangeTracker;
import com.saorsa.tm.Customer;

public class CustomerChooser extends JDialog {

  public static void initialize(Frame owner) {
    dialog = new CustomerChooser(owner);
  }

  public static Customer showDialog(Component comp) {
    if (dialog != null) {
      if (ChangeTracker.getTracker("customer").anyChangeEver()) {
        dialog.setListData(Customer.allCustomerNames().toArray());
      }
      dialog.setVisible(true);
    } else {
      System.err.println("CustomerChooser was not initialized");
    }
    return value;
  }

  private static CustomerChooser dialog;
  private static Customer value = null;

  public CustomerChooser(Frame owner) {
    super(owner, "Choose a Customer", true);

    Container myContentPane = getContentPane();

    JPanel listPane = new JPanel();
    listPane.setLayout(new BoxLayout(listPane, BoxLayout.Y_AXIS));

    JLabel label = new JLabel("Available Customers:");
    listPane.add(label);
    listPane.add(Box.createRigidArea(new Dimension(0, 5)));
    customerList = new JList(Customer.allCustomerNames().toArray());
    JScrollPane CustomerScroller = new JScrollPane(customerList);
    listPane.add(CustomerScroller);
    listPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));

    JButton okButton = new JButton("Ok");
    okButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        CustomerChooser.value =
          Customer.findCustomerByName((String) (customerList.getSelectedValue()));
        CustomerChooser.dialog.setVisible(false);
      }
    });

    JButton cancelButton = new JButton("Cancel");
    cancelButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        CustomerChooser.dialog.setVisible(false);
      }
    });

    JPanel buttonPane = new JPanel();
    buttonPane.setLayout(new BoxLayout(buttonPane, BoxLayout.X_AXIS));
    buttonPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
    buttonPane.add(Box.createHorizontalGlue());
    buttonPane.add(okButton);
    buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
    buttonPane.add(cancelButton);

    myContentPane.add(listPane, BorderLayout.CENTER);
    myContentPane.add(buttonPane, BorderLayout.SOUTH);

    pack();
  }

  protected void setListData(Object[] data) {
    customerList.setListData(data);
  }

  JList customerList;
}