// Copyright (C) 2001 Saorsa Development Inc.

package com.saorsa.tm.printing;

import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.StringTokenizer;

import com.saorsa.tm.*;

/**
 * This class prints quotes.
 */

public class QuotePrinter {

  public QuotePrinter(Quote theQuoteToPrint) {
    myQuote = theQuoteToPrint;
  }

  private String lineOrEmpty(StringTokenizer tokens) {
    return tokens.hasMoreTokens() ? tokens.nextToken() : "";
  }

  public void printTo(Writer writer) {
    try {
      printHeader(writer);
      writer.write(
        MessageFormat.format(
          "<center><img src=\"{0}\"></center></br>\n",
          new Object[] { Company.getInstance().getLogo()}));
      writer.write(
        MessageFormat.format(
          "<b>{0}</b><br>\n",
          new Object[] { Company.getInstance().getName()}));
      writer.write("<table width=\"100%\" cellpadding=\"0\" cellspacing=\"0\">\n");
      StringTokenizer addressLines =
        new StringTokenizer(Company.getInstance().getAddress(), "\n\r");
      writer.write(
        MessageFormat.format(
          "<tr><td>{0}</td><td>Estimate #{1,number,integer}</td></tr>\n",
          new Object[] { lineOrEmpty(addressLines), new Integer(myQuote.getNumber())}));
      writer.write(
        MessageFormat.format(
          "<tr><td>{0}</td><td>Estimate Date: {1,date}</td></tr>\n",
          new Object[] { lineOrEmpty(addressLines), myQuote.getDate()}));
      writer.write(
        MessageFormat.format(
          "<tr><td>{0}</td><td>HST# {1}</td></tr>\n",
          new Object[] { lineOrEmpty(addressLines), Company.getInstance().getHst()}));
      writer.write("</table>\n");
      writer.write("<p>\n<table cellpadding=\"0\" cellspacing=\"0\">\n");
      writer.write("\t<tr>");
      writer.write("<td valign=\"top\">Client:</td>");
      writer.write("<td valign=\"top\">");
      writer.write("<table cellpadding=\"0\" cellspacing=\"0\">\n");
      writer.write(
        MessageFormat.format(
          "\t\t<tr><td>{0}</td></tr>\n",
          new Object[] { myQuote.getCustomer().getName()}));
      StringTokenizer customerAddressLines =
        new StringTokenizer(myQuote.getCustomer().getAddress());
      MessageFormat addressFormatter =
        new MessageFormat("\t\t<tr><td>{0}</td></tr>\n");
      while (customerAddressLines.hasMoreTokens()) {
        writer.write(
          addressFormatter.format(new Object[] { customerAddressLines.nextToken()}));
      }
      writer.write("</table></td></tr></table>");
      writer.write(
        MessageFormat.format(
          "<p>Job: {0}\n<p><table>\n",
          new Object[] { myQuote.getDescription()}));

      MessageFormat itemFormatter =
        new MessageFormat("<tr><td>{0,number,integer}</td><td>{1}</td></tr>\n");
      for (Iterator itemIterator = myQuote.items().iterator();
        itemIterator.hasNext();
        ) {
        Lineitem item = (Lineitem) (itemIterator.next());
        writer.write(
          itemFormatter.format(
            new Object[] { new Integer(item.getQuantity()), item.getDescription()}));
      }
      writer.write("</table>\n");
      writer.write(
        MessageFormat.format(
          "<p>We are pleased to supply a price of {0,number,currency} "
            + "plus HST for the work listed above.\n<p>\n<p>{1}<br>\nPer:",
          new Object[] {
            new Double(myQuote.calculateSubTotal().doubleValue()),
            Company.getInstance().getName()}));
      writer.write("</body></html>");
      writer.flush();
    } catch (IOException ex) {}
  }

  private void printHeader(Writer writer) throws IOException {
    writer.write(
      MessageFormat.format(
        "<html><head><title>Quote #{0,number,integer}</title></head>\n<body>\n",
        new Object[] { new Integer(myQuote.getNumber())}));

  }

  private Quote myQuote = null;
}