// Copyright (C) 2001 Saorsa Development Inc.

package com.saorsa.tm;

import java.io.*;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.*;

import org.xml.sax.AttributeList;
import reh.SaxMapper.SaxMapper;
import reh.SaxMapper.TagTracker;

/**
 * This class represents something that can be sold to a customer.
 */

public class Part {
  public static void addPart(Part thePartToAdd) {
    parts.put(thePartToAdd.getName(), thePartToAdd);
    tracker.set();
  }

  public static void removePart(Part thePartToRemove) {
    parts.remove(thePartToRemove.getName());
    tracker.set();
  }

  public static boolean containsPart(Part thePartToCheckFor) {
    return parts.containsValue(thePartToCheckFor);
  }

  public static Collection allParts() {
    return parts.values();
  }

  public static Set allPartNames() {
    return parts.keySet();
  }

  public static int numberOfParts() {
    return parts.size();
  }

  public static Part findPartByName(String theNameToLookup) {
    if (parts.containsKey(theNameToLookup)) {
      return (Part) parts.get(theNameToLookup);
    } else {
      return nullPart;
    }
  }

  public static void updateFrom(Collection updatedParts) throws IOException {
    clear();
    for (Iterator partIterator = updatedParts.iterator();
      partIterator.hasNext();
      ) {
      addPart((Part) partIterator.next());
    }
    save();
  }

  public static void load(Reader reader) {
    PartLoader loader = new PartLoader();
    loader.fromXML(reader);
    tracker.reset();
  }

  public static void allToXML(Writer writer) throws IOException {
    writer.write("<parts>\n");
    for (Iterator partIterator = parts.values().iterator();
      partIterator.hasNext();
      ) {
      Part aPart = (Part) partIterator.next();
      aPart.toXML(writer);
    }
    writer.write("</parts>\n");
    writer.flush();
  }

  public static void save() throws IOException {
    if (filename != null) {
      FileWriter writer = new FileWriter(filename, false);
      allToXML(writer);
    }
    tracker.reset();
  }

  public static void setFile(String aFilename) throws FileNotFoundException {
    filename = aFilename;
    FileReader reader = new FileReader(filename);
    load(reader);
  }

  public static void clear() {
    parts.clear();
    tracker.reset();
  }

  public static Part makeEmptyPart() {
    return new Part("--Edit this Part--", new BigDecimal(0.0));
  }

  private static Map parts = new TreeMap();
  public static Part nullPart = new Part("", new BigDecimal(0.0));
  public static String filename = null;
  private static ChangeTracker tracker = ChangeTracker.getTracker("part");

  public Part(String aName, BigDecimal aPrice) {
    name = aName;
    price = aPrice;
  }

  public boolean equals(Object anObject) {
    if (anObject == this) {
      return true;
    } else if (anObject instanceof Part) {
      Part aPart = (Part) anObject;
      return name.equals(aPart.name);
    } else {
      return false;
    }
  }

  public int hashCode() {
    int result = 17;
    result = 37 * result + name.hashCode();
    return result;
  }

  public int compareTo(Object objectToCompareTo) {
    Part partToCompareTo = (Part) objectToCompareTo;
    return name.compareTo(partToCompareTo.name);
  }

  public String getName() {
    return name;
  }

  public void setName(String newName) {
    name = newName;
    tracker.set();
  }

  public String toString() {
    StringBuffer buf = new StringBuffer();
    buf.append("Part[");
    buf.append(name);
    buf.append("]");
    return buf.toString();
  }

  public BigDecimal getPrice() {
    return price;
  }

  public void setPrice(BigDecimal newPrice) {
    price = newPrice;
    tracker.set();
  }

  public BigDecimal costForThisMany(int quantity) {
    return price.multiply(new BigDecimal(quantity));
  }

  public void toXML(Writer writer) throws IOException {
    writer.write(
      MessageFormat.format(
        "\t<part name=\"{0}\" price=\"{1,number,0.00}\"/>\n",
        new Object[] { name, new Double(price.doubleValue())}));
  }

  private String name;
  private BigDecimal price;

  private static class PartLoader extends SaxMapper {

    public Object getMappedObject() {
      return null;
    }

    public TagTracker createTagTrackerNetwork() {
       TagTracker root = new TagTracker() {};

       TagTracker partTracker = new TagTracker() {
        public void onStart(String localName, AttributeList atts) {
          String name = atts.getValue("name");
          BigDecimal price = new BigDecimal(atts.getValue("price"));
          Part.addPart(new Part(name, price));
        }
      };
      root.track("/parts/part", partTracker);

      return root;
    }

    public void loadFromFile(String id) throws Exception {
      FileInputStream in = new FileInputStream(id);
      fromXML(in);
    }

  }
}