/*
 * Decompiled with CFR 0.152.
 */
package com.saorsa.util;

import com.ibm.math.BigDecimal;
import com.saorsa.util.Parameters;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;

public class Printf {
    static final String CVS_ID = "$Id$";
    private static final boolean DEBUG = false;
    private static final String FLAG_CHARS = "-lcr+ #0";
    private static final int LEFT = -1;
    private static final int CENTER = 0;
    private static final int RIGHT = 1;
    private static final char TOO_WIDE_CHAR = '#';
    private static final char NO_PARAM_CHAR = '*';
    private static final char BAD_PARAM_CHAR = '?';

    private Printf() {
    }

    public static void printf(String theFormatString, Parameters theParameters) {
        StringBuffer sb = new StringBuffer();
        Printf.format(sb, theFormatString, theParameters);
        System.out.print(sb.toString());
    }

    public static void printf(String theFormatString) {
        Printf.printf(theFormatString, null);
    }

    public static void errprintf(String theFormatString, Parameters theParameters) {
        StringBuffer sb = new StringBuffer();
        Printf.format(sb, theFormatString, theParameters);
        System.err.print(sb.toString());
    }

    public static void errprintf(String theFormatString) {
        Printf.errprintf(theFormatString, null);
    }

    public static String sprintf(String theFormatString, Parameters theParameters) {
        StringBuffer sb = new StringBuffer();
        Printf.format(sb, theFormatString, theParameters);
        return sb.toString();
    }

    public static String sprintf(String theFormatString) {
        return Printf.sprintf(theFormatString, null);
    }

    public static void sbufprintf(StringBuffer aStringBuffer, String theFormatString, Parameters theParameters) {
        Printf.format(aStringBuffer, theFormatString, theParameters);
    }

    public static void sbufprintf(StringBuffer aStringBuffer, String theFormatString) {
        Printf.sbufprintf(aStringBuffer, theFormatString, null);
    }

    public static void wprintf(Writer aWriter, String theFormatString, Parameters theParameters) {
        StringBuffer sb = new StringBuffer();
        Printf.format(sb, theFormatString, theParameters);
        try {
            aWriter.write(sb.toString());
            aWriter.flush();
        }
        catch (IOException e) {
            System.err.println("IOException during wprintf");
            e.printStackTrace();
        }
    }

    public static void wprintf(Writer aWriter, String theFormatString) {
        Printf.wprintf(aWriter, theFormatString, null);
    }

    private static final Object getNextParameterOrNull(Enumeration someParameters) {
        if (someParameters.hasMoreElements()) {
            return someParameters.nextElement();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private static final void format(StringBuffer aStringBuffer, String theFormatString, Parameters theParameters) {
        block42: {
            block41: {
                if (theParameters != null) break block41;
                aStringBuffer.append(theFormatString);
                break block42;
            }
            params = theParameters.parameters();
            index = -1;
            limit = theFormatString.length();
            param = null;
            lookahead = ' ';
            while (index < limit - 1) {
                block43: {
                    block45: {
                        block44: {
                            if ((lookahead = (char)theFormatString.charAt(++index)) != 37) break block43;
                            justification = 1;
                            useSign = false;
                            useSpace = false;
                            useAlternative = false;
                            zeroFill = false;
                            fieldWidth = 0;
                            precision = 0;
                            param = Printf.getNextParameterOrNull(params);
                            lookahead = theFormatString.charAt(++index);
                            while (index < limit && "-lcr+ #0".indexOf(lookahead) > -1) {
                                switch (lookahead) {
                                    case '-': 
                                    case 'L': 
                                    case 'l': {
                                        justification = -1;
                                        Printf.log("flag: justification: LEFT");
                                        break;
                                    }
                                    case 'C': 
                                    case 'c': {
                                        justification = 0;
                                        Printf.log("flag: justification: CENTER");
                                        break;
                                    }
                                    case 'R': 
                                    case 'r': {
                                        justification = 1;
                                        Printf.log("flag: justification RIGHT");
                                        break;
                                    }
                                    case '+': {
                                        useSign = true;
                                        useSpace = false;
                                        Printf.log("flag: use sign");
                                        break;
                                    }
                                    case ' ': {
                                        useSpace = useSign == false;
                                        Printf.log("flag: use space");
                                        break;
                                    }
                                    case '#': {
                                        useAlternative = true;
                                        Printf.log("flag: use alternative");
                                        break;
                                    }
                                    case '0': {
                                        zeroFill = true;
                                        Printf.log("flag: zero fill");
                                    }
                                }
                                lookahead = theFormatString.charAt(++index);
                            }
                            if (lookahead != 42) ** GOTO lbl63
                            if (param != null && param instanceof Integer) {
                                fieldWidth = (Integer)param;
                                param = Printf.getNextParameterOrNull(params);
                            }
                            lookahead = theFormatString.charAt(++index);
                            break block44;
lbl-1000:
                            // 1 sources

                            {
                                fieldWidth *= 10;
                                fieldWidth += Character.getNumericValue(lookahead);
                                lookahead = theFormatString.charAt(++index);
lbl63:
                                // 2 sources

                                ** while (index < limit && Character.isDigit((char)lookahead))
                            }
                        }
                        Printf.log("fieldwidth = " + Integer.toString(fieldWidth));
                        if (index >= limit || lookahead != 46) break block45;
                        if ((lookahead = theFormatString.charAt(++index)) != 42) ** GOTO lbl76
                        if (param != null && param instanceof Integer) {
                            precision = (Integer)param;
                            param = Printf.getNextParameterOrNull(params);
                        }
                        lookahead = theFormatString.charAt(++index);
                        break block45;
lbl-1000:
                        // 1 sources

                        {
                            precision *= 10;
                            precision += Character.getNumericValue(lookahead);
                            lookahead = theFormatString.charAt(++index);
lbl76:
                            // 2 sources

                            ** while (index < limit && Character.isDigit((char)lookahead))
                        }
                    }
                    Printf.log("precision = " + Integer.toString(precision));
                    if (param == null) {
                        Printf.outputErrorField(aStringBuffer, fieldWidth, '?');
                        continue;
                    }
                    val = 0;
                    prefixLength = 0;
                    prefix = null;
                    switch (lookahead) {
                        case 'b': {
                            if (param instanceof Boolean) {
                                b = (Boolean)param;
                                aStringBuffer.append(Printf.justify("", useAlternative ? (b.booleanValue() ? "t" : "f") : b.toString(), fieldWidth, justification));
                                break;
                            }
                            Printf.outputErrorField(aStringBuffer, fieldWidth, '?');
                            break;
                        }
                        case 'B': {
                            if (param instanceof Boolean) {
                                b = (Boolean)param;
                                aStringBuffer.append(Printf.justify("", useAlternative ? (b.booleanValue() ? "T" : "F") : b.toString().toUpperCase(), fieldWidth, justification));
                                break;
                            }
                            Printf.outputErrorField(aStringBuffer, fieldWidth, '?');
                            break;
                        }
                        case 'd': 
                        case 'i': {
                            if (param instanceof Integer) {
                                val = (Integer)param;
                                prefix = "";
                                prefixLength = 0;
                                if (val >= 0) {
                                    if (useSign) {
                                        prefixLength = 1;
                                        prefix = "+";
                                    } else if (useSpace) {
                                        prefixLength = 1;
                                        prefix = " ";
                                    }
                                } else {
                                    prefixLength = 1;
                                }
                                aStringBuffer.append(Printf.justify(prefix, Printf.fill(zeroFill, fieldWidth - prefixLength, Integer.toString(val), precision), fieldWidth, justification));
                                break;
                            }
                            Printf.outputErrorField(aStringBuffer, fieldWidth, '?');
                            break;
                        }
                        case 'x': {
                            if (param instanceof Integer) {
                                val = (Integer)param;
                                aStringBuffer.append(Printf.justify(useAlternative != false ? "0x" : "", Printf.fill(zeroFill, fieldWidth - (useAlternative != false ? 2 : 0), Integer.toHexString(val), precision), fieldWidth, justification));
                                break;
                            }
                            Printf.outputErrorField(aStringBuffer, fieldWidth, '?');
                            break;
                        }
                        case 'X': {
                            if (param instanceof Integer) {
                                val = (Integer)param;
                                aStringBuffer.append(Printf.justify(useAlternative != false ? "0X" : "", Printf.fill(zeroFill, fieldWidth - (useAlternative != false ? 2 : 0), Integer.toHexString(val).toUpperCase(), precision), fieldWidth, justification));
                                break;
                            }
                            Printf.outputErrorField(aStringBuffer, fieldWidth, '?');
                            break;
                        }
                        case 'f': {
                            if (param instanceof Double) {
                                aStringBuffer.append(Printf.justify("", Printf.formatFloat((Double)param, precision, useAlternative), fieldWidth, justification));
                                break;
                            }
                            Printf.outputErrorField(aStringBuffer, fieldWidth, '?');
                            break;
                        }
                        case 'c': {
                            if (param instanceof Character) {
                                aStringBuffer.append(Printf.justify("", ((Character)param).toString(), fieldWidth, justification));
                                break;
                            }
                            Printf.outputErrorField(aStringBuffer, fieldWidth, '?');
                            break;
                        }
                        case 's': {
                            if (param instanceof String) {
                                aStringBuffer.append(Printf.justify("", Printf.trim((String)param, precision), fieldWidth, justification));
                                break;
                            }
                            Printf.outputErrorField(aStringBuffer, fieldWidth, '?');
                            break;
                        }
                        case 'o': {
                            aStringBuffer.append(Printf.justify("", param.toString(), fieldWidth, justification));
                            break;
                        }
                        case '%': {
                            aStringBuffer.append('%');
                        }
                    }
                    continue;
                }
                aStringBuffer.append(lookahead);
            }
            theParameters.clear();
        }
    }

    private static String trim(String aString, int maxSize) {
        if (maxSize == 0 || aString.length() <= maxSize) {
            return aString;
        }
        return aString.substring(0, maxSize);
    }

    private static void outputErrorField(StringBuffer aStringBuffer, int theFieldWidth, char theErrorCharacter) {
        if (theFieldWidth == 0) {
            theFieldWidth = 1;
        }
        int i = 0;
        while (i < theFieldWidth) {
            aStringBuffer.append(theErrorCharacter);
            ++i;
        }
    }

    private static String formatFloat(double aDouble, int precision, boolean insertCommas) {
        String rawValue = BigDecimal.valueOf((double)aDouble).format(-1, precision);
        if (insertCommas) {
            StringBuffer scratch = new StringBuffer();
            boolean useCommas = false;
            int count = 0;
            int i = rawValue.length() - 1;
            while (i >= 0) {
                if (useCommas && ++count == 3 && Character.isDigit(rawValue.charAt(i))) {
                    scratch.append(',');
                    count = 0;
                }
                if (rawValue.charAt(i) == '.') {
                    useCommas = true;
                    count = -1;
                }
                scratch.append(rawValue.charAt(i));
                --i;
            }
            return scratch.reverse().toString();
        }
        return rawValue;
    }

    private static String fill(boolean zeroFill, int fieldWidth, String theString, int precision) {
        int minSize = 0;
        if (precision > 0) {
            minSize = precision;
        } else if (zeroFill) {
            minSize = fieldWidth;
        }
        String result = theString;
        if (minSize > 0) {
            String digitString = null;
            String leadChars = "+- ";
            char leadChar = theString.charAt(0);
            boolean hasLeadChar = leadChars.indexOf(leadChar) > -1;
            String string = digitString = hasLeadChar ? theString.substring(1) : theString;
            if (digitString.length() < minSize) {
                StringBuffer buf = new StringBuffer();
                if (hasLeadChar) {
                    buf.append(leadChar);
                }
                int i = digitString.length();
                while (i < minSize) {
                    buf.append('0');
                    ++i;
                }
                buf.append(digitString);
                result = buf.toString();
            }
        }
        return result;
    }

    private static String justify(String prefix, String aString, int aFieldWidth, int aJustification) {
        StringBuffer result = new StringBuffer();
        int stringLength = prefix.length() + aString.length();
        if (aFieldWidth == 0 || stringLength > aFieldWidth) {
            result.append(prefix);
            result.append(aString);
        } else {
            int leftFill = 0;
            int rightFill = 0;
            int difference = aFieldWidth - stringLength;
            switch (aJustification) {
                case -1: {
                    rightFill = difference;
                    break;
                }
                case 0: {
                    rightFill = difference / 2;
                    leftFill = difference - rightFill;
                    break;
                }
                case 1: {
                    leftFill = difference;
                }
            }
            int i = 0;
            while (i < leftFill) {
                result.append(' ');
                ++i;
            }
            result.append(prefix);
            result.append(aString);
            int i2 = 0;
            while (i2 < rightFill) {
                result.append(' ');
                ++i2;
            }
        }
        return result.toString();
    }

    private static void log(String aString) {
    }
}

