/*
 * Decompiled with CFR 0.152.
 */
package com.saorsa.util;

public class Queue {
    static final String CVS_ID = "$Id$";
    private static final int DEFAULT_SIZE = 16;
    protected Object[] storage;
    protected int head = 0;
    protected int tail = 0;

    public Queue() {
        this(16);
    }

    public Queue(int initialSize) {
        this.storage = new Object[initialSize];
        this.head = 0;
        this.tail = 0;
    }

    public synchronized boolean enqueue(Object anObject) {
        if (this.isFull()) {
            return false;
        }
        this.storage[this.head] = anObject;
        this.head = (this.head + 1) % this.storage.length;
        return true;
    }

    public synchronized Object dequeue() {
        if (this.isEmpty()) {
            return null;
        }
        Object anItem = this.storage[this.tail];
        this.tail = (this.tail + 1) % this.storage.length;
        return anItem;
    }

    public synchronized boolean isFull() {
        return (this.head + 1) % this.storage.length == this.tail;
    }

    public synchronized boolean isEmpty() {
        return this.head == this.tail;
    }

    public synchronized int capacity() {
        return this.storage.length - 1;
    }

    public synchronized int size() {
        return (this.storage.length + this.head - this.tail) % this.storage.length;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Head: ");
        sb.append(this.head);
        sb.append(" tail: ");
        sb.append(this.tail);
        sb.append("\tsize: ");
        sb.append(this.size());
        sb.append(" capacity: ");
        sb.append(this.capacity());
        return sb.toString();
    }
}

