/*
 * Decompiled with CFR 0.152.
 */
package com.saorsa.util;

import com.saorsa.util.KSStringTokenizer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ArgChecker {
    static final String CVS_ID = "$Id$";
    public static final String VERSION = "2.0";
    private String m_description = null;
    private String[] m_args = null;
    private boolean m_permitExtraArgs = false;
    private Hashtable m_values = null;
    private Hashtable m_flags = null;

    public ArgChecker(String p_description, String[] p_args, boolean p_permitExtraArgs) throws IllegalArgumentException {
        if (p_description == null || p_description.length() == 0) {
            throw new IllegalArgumentException("description");
        }
        this.m_description = p_description;
        this.m_args = p_args;
        this.m_permitExtraArgs = p_permitExtraArgs;
        this.m_values = new Hashtable();
        this.m_flags = new Hashtable();
    }

    public ArgChecker(String p_description, String[] p_args) throws IllegalArgumentException {
        this(p_description, p_args, false);
    }

    public String getUsageString() {
        return this.m_description;
    }

    public boolean isValid() {
        String argString = "";
        int numArgs = this.m_args.length;
        int i = 0;
        while (i < numArgs) {
            argString = argString + this.m_args[i] + " ";
            ++i;
        }
        return this.isValid(new KSStringTokenizer(argString), this.m_description, this.m_permitExtraArgs);
    }

    public String paramNamed(String p_paramID) {
        return (String)this.m_values.get(p_paramID);
    }

    public boolean switchFound(String p_switchID) {
        return this.m_flags.get(p_switchID) != null;
    }

    private boolean isValid(KSStringTokenizer p_argTokenizer, String p_description, boolean p_permitExtraArgs) {
        if (this.numSections(p_description, '|') > 1) {
            Vector subBlocks = this.seperateBlocks(p_description, '|');
            if (!p_argTokenizer.hasMoreTokens()) {
                int i = 0;
                while (i < subBlocks.size()) {
                    if (this.minNumber((String)subBlocks.elementAt(i)) == 0) {
                        return true;
                    }
                    ++i;
                }
                return p_permitExtraArgs;
            }
            String tok = p_argTokenizer.nextToken();
            int count = 0;
            int i = 0;
            while (i < subBlocks.size()) {
                Vector firsts = this.firstTokens((String)subBlocks.elementAt(i));
                int j = 0;
                while (j < firsts.size()) {
                    if (this.match((String)firsts.elementAt(j), tok)) {
                        ++count;
                    }
                    ++j;
                }
                ++i;
            }
            if (count == 0) {
                p_argTokenizer.backup();
                return p_permitExtraArgs;
            }
            if (count > 1) {
                return false;
            }
            String subDescription = "";
            int i2 = 0;
            block3: while (i2 < subBlocks.size()) {
                Vector firsts = this.firstTokens((String)subBlocks.elementAt(i2));
                int j = 0;
                while (j < firsts.size()) {
                    if (this.match((String)firsts.elementAt(j), tok)) {
                        p_argTokenizer.backup();
                        subDescription = (String)subBlocks.elementAt(i2);
                        break block3;
                    }
                    ++j;
                }
                ++i2;
            }
            return this.isValid(p_argTokenizer, subDescription, p_permitExtraArgs);
        }
        int min = this.minNumber(p_description);
        int max = this.maxNumber(p_description);
        if (p_argTokenizer.countTokens() < min) {
            return false;
        }
        if (p_argTokenizer.countTokens() > max && !p_permitExtraArgs) {
            return false;
        }
        KSStringTokenizer desTokenizer = new KSStringTokenizer(p_description);
        boolean optionalBlock = false;
        block5: while (true) {
            String optionalDescription;
            String tok;
            if (!p_argTokenizer.hasMoreTokens()) {
                while (desTokenizer.hasMoreTokens()) {
                    tok = desTokenizer.nextToken();
                    if (tok.equals("]")) {
                        optionalBlock = false;
                        continue;
                    }
                    if (tok.equals("[")) {
                        optionalBlock = true;
                        continue;
                    }
                    if (optionalBlock) continue;
                    return false;
                }
                return !optionalBlock;
            }
            String currArgToken = p_argTokenizer.nextToken();
            while (true) {
                if (!desTokenizer.hasMoreTokens()) {
                    p_argTokenizer.backup();
                    return p_permitExtraArgs;
                }
                tok = desTokenizer.nextToken();
                if (this.match(currArgToken, tok)) {
                    if (tok.charAt(0) == '-') {
                        this.m_flags.put(tok, Boolean.TRUE);
                        continue block5;
                    }
                    this.m_values.put(tok, currArgToken);
                    continue block5;
                }
                if (!(tok.equals("[") || tok.equals("]") || tok.equals("|"))) {
                    return false;
                }
                if (!tok.equals("[")) continue;
                optionalDescription = "";
                int depth = 1;
                while (true) {
                    if (!desTokenizer.hasMoreTokens()) {
                        return false;
                    }
                    String tmpTok = desTokenizer.nextToken();
                    if (tmpTok.equals("[")) {
                        ++depth;
                    }
                    if (tmpTok.equals("]") && --depth == 0) break;
                    optionalDescription = optionalDescription + tmpTok + " ";
                }
                Vector firsts = this.firstTokens(optionalDescription);
                boolean matchMade = false;
                int i = 0;
                while (i < firsts.size()) {
                    if (this.match((String)firsts.elementAt(i), currArgToken)) {
                        if (matchMade) {
                            return false;
                        }
                        matchMade = true;
                    }
                    ++i;
                }
                if (matchMade) break;
            }
            p_argTokenizer.backup();
            if (!this.isValid(p_argTokenizer, optionalDescription, true)) break;
        }
        return false;
    }

    public int minNumber(String description) {
        KSStringTokenizer desTokenizer = new KSStringTokenizer(description);
        int count = 0;
        if (this.numSections(description, '|') < 1) {
            return -1;
        }
        if (this.numSections(description, '|') > 1) {
            Vector subBlocks = this.seperateBlocks(description, '|');
            int smallest = this.minNumber((String)subBlocks.elementAt(0));
            int i = 1;
            while (i < subBlocks.size()) {
                if (this.minNumber((String)subBlocks.elementAt(i)) < smallest) {
                    smallest = this.minNumber((String)subBlocks.elementAt(i));
                }
                ++i;
            }
            return smallest;
        }
        int depth = 0;
        while (desTokenizer.hasMoreTokens()) {
            String token = desTokenizer.nextToken();
            if (token.equals("[")) {
                ++depth;
                continue;
            }
            if (token.equals("]")) {
                --depth;
                continue;
            }
            if (depth != 0) continue;
            ++count;
        }
        if (depth != 0) {
            return -1;
        }
        return count;
    }

    /*
     * Unable to fully structure code
     */
    public int maxNumber(String description) {
        desTokenizer = new KSStringTokenizer(description);
        count = 0;
        if (this.numSections(description, '|') < 1) {
            return -1;
        }
        if (this.numSections(description, '|') <= 1) ** GOTO lbl31
        subBlocks = this.seperateBlocks(description, '|');
        biggest = this.maxNumber((String)subBlocks.elementAt(0));
        i = 1;
        while (i < subBlocks.size()) {
            if (this.maxNumber((String)subBlocks.elementAt(i)) > biggest) {
                biggest = this.maxNumber((String)subBlocks.elementAt(i));
            }
            ++i;
        }
        return biggest;
lbl-1000:
        // 1 sources

        {
            token = desTokenizer.nextToken();
            if (token.equals("[")) {
                optionalDescription = "";
                depth = 1;
                while (true) {
                    if (!desTokenizer.hasMoreTokens()) {
                        return -1;
                    }
                    tmpTok = desTokenizer.nextToken();
                    if (tmpTok.equals("[")) {
                        ++depth;
                    }
                    if (tmpTok.equals("]") && --depth == 0) break;
                    optionalDescription = optionalDescription + tmpTok + " ";
                }
                count += this.maxNumber(optionalDescription);
                continue;
            }
            ++count;
lbl31:
            // 3 sources

            ** while (desTokenizer.hasMoreTokens())
        }
lbl32:
        // 1 sources

        return count;
    }

    private boolean match(String p_arg, String p_tok) {
        if (p_tok.equals("[") || p_tok.equals("]") || p_tok.equals("|")) {
            return false;
        }
        if (p_arg.startsWith("-") ? !p_tok.startsWith("-") : p_tok.startsWith("-")) {
            return false;
        }
        if (p_arg.charAt(0) == '-' && p_tok.charAt(0) == '-') {
            return p_arg.equals(p_tok);
        }
        return true;
    }

    private Vector firstTokens(String p_description) {
        KSStringTokenizer tokenizer = new KSStringTokenizer(p_description);
        Vector firsts = new Vector();
        while (tokenizer.hasMoreTokens()) {
            String tok = tokenizer.nextToken();
            if (tok.equals("[")) {
                String optionalDescription = "";
                int depth = 1;
                while (true) {
                    if (!tokenizer.hasMoreTokens()) {
                        return null;
                    }
                    String tmpTok = tokenizer.nextToken();
                    if (tmpTok.equals("[")) {
                        ++depth;
                    }
                    if (tmpTok.equals("]") && --depth == 0) break;
                    optionalDescription = optionalDescription + tmpTok + " ";
                }
                Vector subFirsts = this.firstTokens(optionalDescription);
                if (subFirsts == null) {
                    return null;
                }
                int i = 0;
                while (i < subFirsts.size()) {
                    firsts.addElement(subFirsts.elementAt(i));
                    ++i;
                }
                continue;
            }
            firsts.addElement(tok);
            return firsts;
        }
        return firsts;
    }

    private int numSections(String p_description, char p_sep) {
        int depth = 0;
        int numSections = 1;
        KSStringTokenizer tokenizer = new KSStringTokenizer(p_description);
        while (tokenizer.hasMoreTokens()) {
            String tok = tokenizer.nextToken();
            if (tok.equals("[")) {
                ++depth;
                continue;
            }
            if (tok.equals("]")) {
                --depth;
                continue;
            }
            if (tok.charAt(0) != p_sep || depth != 0) continue;
            ++numSections;
        }
        if (depth != 0) {
            return 0;
        }
        return numSections;
    }

    private Vector seperateBlocks(String p_description, char p_sep) {
        int numSections = this.numSections(p_description, p_sep);
        int depth = 0;
        Vector<String> sections = new Vector<String>();
        String currBlock = "";
        KSStringTokenizer tokenizer = new KSStringTokenizer(p_description);
        int i = 0;
        while (i < numSections) {
            String tok;
            while (tokenizer.hasMoreTokens() && ((tok = tokenizer.nextToken()).charAt(0) != p_sep || depth != 0)) {
                currBlock = currBlock + tok + " ";
                if (tok.equals("[")) {
                    ++depth;
                }
                if (!tok.equals("]")) continue;
                --depth;
            }
            sections.addElement(currBlock.trim());
            currBlock = "";
            ++i;
        }
        return sections;
    }

    void dumpValues() {
        String key;
        System.out.println("Keys");
        Enumeration keys = this.m_flags.keys();
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            System.out.println("   " + key);
        }
        System.out.println("Values");
        keys = this.m_values.keys();
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            System.out.println("   " + key + " -> " + this.m_values.get(key));
        }
    }
}

