/*
 * Decompiled with CFR 0.152.
 */
package reh.SaxMapper;

import java.io.CharArrayWriter;
import java.util.Hashtable;
import java.util.Stack;
import org.xml.sax.AttributeList;
import reh.SaxMapper.SaxMapperLog;
import reh.SaxMapper.SkippingTagTracker;

public class TagTracker {
    private Hashtable trackers = new Hashtable();
    private static SkippingTagTracker skip = new SkippingTagTracker();

    public void track(String string, TagTracker tagTracker) {
        int n = string.indexOf("/");
        if (n < 0) {
            this.trackers.put(string, tagTracker);
        } else if (n == 0) {
            this.track(string.substring(1), tagTracker);
        } else {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            TagTracker tagTracker2 = (TagTracker)this.trackers.get(string2);
            if (tagTracker2 == null) {
                tagTracker2 = new TagTracker();
                this.trackers.put(string2, tagTracker2);
            }
            tagTracker2.track(string3, tagTracker);
        }
    }

    public void startElement(String string, AttributeList attributeList, Stack stack) {
        TagTracker tagTracker = (TagTracker)this.trackers.get(string);
        if (tagTracker == null) {
            SaxMapperLog.trace("Skipping tag: [" + string + "]");
            stack.push(skip);
        } else {
            SaxMapperLog.trace("Tracking tag: [" + string + "]");
            SaxMapperLog.trace("Deactivating current tracker.");
            this.onDeactivate();
            SaxMapperLog.trace("Sending start event to [" + string + "] tracker.");
            tagTracker.onStart(string, attributeList);
            stack.push(tagTracker);
        }
    }

    public void endElement(String string, CharArrayWriter charArrayWriter, Stack stack) {
        SaxMapperLog.trace("Finished tracking tag: [" + string + "]");
        this.onEnd(string, charArrayWriter);
        stack.pop();
        TagTracker tagTracker = (TagTracker)stack.peek();
        if (tagTracker != null) {
            SaxMapperLog.trace("Reactivating previous tag tracker.");
            tagTracker.onReactivate();
        }
    }

    public void onStart(String string, AttributeList attributeList) {
    }

    public void onDeactivate() {
    }

    public void onEnd(String string, CharArrayWriter charArrayWriter) {
    }

    public void onReactivate() {
    }
}

