/*
 * Decompiled with CFR 0.152.
 */
package reh.SaxMapper;

import java.io.CharArrayWriter;
import java.io.InputStream;
import java.io.Reader;
import java.util.Stack;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.ParserFactory;
import reh.SaxMapper.SaxMapperLog;
import reh.SaxMapper.TagTracker;

public abstract class SaxMapper
extends HandlerBase {
    private static final String DEFAULT_PARSER_NAME = "org.apache.xerces.parsers.SAXParser";
    private Stack tagStack = new Stack();
    Parser parser;
    private CharArrayWriter contents = new CharArrayWriter();

    public abstract Object getMappedObject();

    public abstract TagTracker createTagTrackerNetwork();

    public SaxMapper() {
        try {
            this.parser = ParserFactory.makeParser(DEFAULT_PARSER_NAME);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        SaxMapperLog.trace("Creating the tag tracker network.");
        this.tagStack.push(this.createTagTrackerNetwork());
        SaxMapperLog.trace("Tag tracker network created.");
    }

    public Object fromXML(String string) {
        try {
            return this.fromXML(new InputSource(string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public Object fromXML(InputStream inputStream) {
        try {
            return this.fromXML(new InputSource(inputStream));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public Object fromXML(Reader reader) {
        try {
            return this.fromXML(new InputSource(reader));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private synchronized Object fromXML(InputSource inputSource) throws Exception {
        this.parser.setDocumentHandler(this);
        this.parser.setErrorHandler(this);
        SaxMapperLog.trace("About to parse XML document.");
        this.parser.parse(inputSource);
        SaxMapperLog.trace("XML document parsing complete.");
        return this.getMappedObject();
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        SaxMapperLog.trace("startElement " + string);
        this.contents.reset();
        TagTracker tagTracker = (TagTracker)this.tagStack.peek();
        tagTracker.startElement(string, attributeList, this.tagStack);
    }

    public void endElement(String string) throws SAXException {
        SaxMapperLog.trace("endElement " + string);
        TagTracker tagTracker = (TagTracker)this.tagStack.peek();
        tagTracker.endElement(string, this.contents, this.tagStack);
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.contents.write(cArray, n, n2);
    }
}

