/*
 * Decompiled with CFR 0.152.
 */
package com.saorsa.util;

import com.saorsa.util.Parameters;
import com.saorsa.util.Printf;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.StringTokenizer;

public class Ftp {
    private static final boolean LOCAL_OUTPUT = true;
    private static final int IO_ERROR = 0;
    private static final int PRELIM = 1;
    private static final int COMPLETE = 2;
    private static final int CONTINUE = 3;
    private static final int TRANSIENT = 4;
    private static final int ERROR = 5;
    private static final int FTP_PORT = 21;
    private Socket echoSocket = null;
    private PrintStream os = null;
    private DataInputStream is = null;

    public boolean open(String hostname, String username, String password) {
        boolean result = true;
        if (this.echoSocket == null) {
            Parameters p = new Parameters().add(hostname);
            if (hostname == null || hostname.length() == 0) {
                Printf.errprintf("Bad hostname");
                result = false;
            } else {
                try {
                    this.echoSocket = new Socket(hostname, 21);
                    this.os = new PrintStream(this.echoSocket.getOutputStream());
                    this.is = new DataInputStream(this.echoSocket.getInputStream());
                    this.getReply(this.is);
                    this.os.println("USER " + username);
                    this.getReply(this.is);
                    this.os.println("PASS " + password);
                    this.getReply(this.is);
                }
                catch (UnknownHostException e) {
                    Printf.errprintf("Don't know about host: %s\n", p);
                    result = false;
                }
                catch (IOException e) {
                    Printf.errprintf("Couldn't get I/O for the connection to: %s\n", p);
                    result = false;
                }
            }
        } else {
            Printf.errprintf("Connection already active: %o\n", new Parameters().add(this.echoSocket));
            result = false;
        }
        return result;
    }

    public void close() {
        if (this.echoSocket == null) {
            Printf.errprintf("Connection not active\n");
        } else {
            this.doCommand("QUIT");
            try {
                try {
                    this.os.close();
                    this.is.close();
                    this.echoSocket.close();
                }
                catch (IOException ex) {
                    Object var3_2 = null;
                    this.echoSocket = null;
                    this.os = null;
                    this.is = null;
                }
                Object var3_1 = null;
                this.echoSocket = null;
                this.os = null;
                this.is = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.echoSocket = null;
                this.os = null;
                this.is = null;
                throw throwable;
            }
        }
    }

    public void ensureCleanedUp() {
        try {
            block6: {
                try {
                    if (this.os != null) {
                        this.os.close();
                    }
                    if (this.is != null) {
                        this.is.close();
                    }
                    if (this.echoSocket == null) break block6;
                    this.echoSocket.close();
                }
                catch (IOException ex) {
                    Object var3_2 = null;
                    this.echoSocket = null;
                    this.os = null;
                    this.is = null;
                }
            }
            Object var3_1 = null;
            this.echoSocket = null;
            this.os = null;
            this.is = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.echoSocket = null;
            this.os = null;
            this.is = null;
            throw throwable;
        }
    }

    public boolean isConnected() {
        boolean result = true;
        result = this.echoSocket == null ? false : this.doCommand("SYST");
        return result;
    }

    public boolean doCommand(String theCommand) {
        if (theCommand.startsWith("LIST") || theCommand.startsWith("NLST")) {
            return this.doDataPort(theCommand, false, this.is, this.os);
        }
        if (theCommand.startsWith("RETR")) {
            return this.doDataPort(theCommand, true, this.is, this.os);
        }
        System.out.println(theCommand);
        this.os.println(theCommand);
        int result = this.getReply(this.is);
        return result != 5 && result != 4 && result != 0;
    }

    public int getReply(DataInputStream is) {
        String sockoutput;
        try {
            do {
                sockoutput = is.readLine();
                System.out.println(sockoutput);
            } while (!Character.isDigit(sockoutput.charAt(0)) || !Character.isDigit(sockoutput.charAt(1)) || !Character.isDigit(sockoutput.charAt(2)) || sockoutput.charAt(3) != ' ');
        }
        catch (IOException e) {
            return 0;
        }
        return Integer.parseInt(sockoutput.substring(0, 1));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean doDataPort(String command, boolean saveToFile, DataInputStream incontrolport, PrintStream outcontrolport) {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(0);
        }
        catch (IOException e) {
            Printf.errprintf("Could not get port for listening: %d, %o\n", new Parameters().add(serverSocket.getLocalPort()).add(e));
            return false;
        }
        this.port(serverSocket, incontrolport, outcontrolport);
        if (saveToFile) {
            outcontrolport.println("type i");
            System.out.println("type i");
            this.getReply(incontrolport);
        }
        outcontrolport.println(command);
        System.out.println(command);
        int result = this.getReply(incontrolport);
        if (result == 1) {
            Socket clientSocket = null;
            try {
                clientSocket = serverSocket.accept();
            }
            catch (IOException e) {
                Printf.errprintf("Accept failed: %d, %o\n", new Parameters().add(serverSocket.getLocalPort()).add(e));
            }
            try {
                InputStream is;
                block16: {
                    int amount2;
                    is = clientSocket.getInputStream();
                    byte[] b = new byte[1024];
                    if (saveToFile) {
                        StringTokenizer stringtokens = new StringTokenizer(command);
                        stringtokens.nextToken();
                        String filename = stringtokens.nextToken();
                        RandomAccessFile outfile = new RandomAccessFile(filename, "rw");
                        while (true) {
                            void var10_17;
                            int amount2;
                            if ((amount2 = is.read(b)) == -1) {
                                System.out.print("\n");
                                outfile.close();
                                break block16;
                            }
                            outfile.write(b, 0, (int)var10_17);
                            System.out.print("#");
                        }
                    }
                    while ((amount2 = is.read(b)) != -1) {
                        System.out.write(b, 0, amount2);
                    }
                }
                this.getReply(incontrolport);
                is.close();
                clientSocket.close();
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        System.err.println("Error calling for download");
        try {
            try {
                serverSocket.close();
                return false;
            }
            catch (IOException e) {
                System.err.println("Error closing server socket.");
                return false;
            }
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public boolean upload(String filename) {
        File theFile = new File(filename);
        String command = "STOR " + theFile.getName();
        return this.primUpload(filename, command, this.is, this.os);
    }

    /*
     * WARNING - void declaration
     */
    public boolean primUpload(String filename, String command, DataInputStream incontrolport, PrintStream outcontrolport) {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(0);
        }
        catch (IOException e) {
            System.err.println("Could not get port for listening:  " + serverSocket.getLocalPort() + ", " + e);
            return false;
        }
        this.port(serverSocket, incontrolport, outcontrolport);
        outcontrolport.println("type i");
        System.out.println("type i");
        this.getReply(incontrolport);
        outcontrolport.println(command);
        System.out.println(command);
        int result = this.getReply(incontrolport);
        if (result == 1) {
            Socket clientSocket = null;
            try {
                clientSocket = serverSocket.accept();
            }
            catch (IOException e) {
                System.err.println("Accept failed: " + serverSocket.getLocalPort() + ", " + e);
            }
            try {
                int amount;
                OutputStream outdataport = clientSocket.getOutputStream();
                byte[] b = new byte[1024];
                RandomAccessFile infile = new RandomAccessFile(filename, "r");
                while ((amount = infile.read(b)) > 0) {
                    void var11_15;
                    outdataport.write(b, 0, (int)var11_15);
                    System.out.print("#");
                }
                System.out.print("\n");
                infile.close();
                outdataport.close();
                clientSocket.close();
                serverSocket.close();
                result = this.getReply(incontrolport);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return result == 2;
        }
        System.err.println("Error calling for download");
        try {
            serverSocket.close();
        }
        catch (IOException e) {
            System.err.println("Error closing server socket.");
        }
        return false;
    }

    public boolean port(ServerSocket serverSocket, DataInputStream incontrolport, PrintStream outcontrolport) {
        InetAddress localip;
        int localport = serverSocket.getLocalPort();
        System.out.println("Will listen on port, " + localport);
        InetAddress inetaddress = serverSocket.getInetAddress();
        try {
            localip = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            System.err.println("can't get local host");
            return false;
        }
        byte[] addrbytes = localip.getAddress();
        short[] addrshorts = new short[4];
        int i = 0;
        while (i < 4) {
            addrshorts[i] = addrbytes[i];
            if (addrshorts[i] < 0) {
                int n = i;
                addrshorts[n] = (short)(addrshorts[n] + 256);
            }
            ++i;
        }
        String s = Printf.sprintf("port %d,%d,%d,%d,%d,%d", new Parameters().add(addrshorts[0]).add(addrshorts[1]).add(addrshorts[2]).add(addrshorts[3]).add((localport & 0xFF00) >> 8).add(localport & 0xFF));
        outcontrolport.println(s);
        System.out.println(s);
        int result = this.getReply(incontrolport);
        return result == 2;
    }
}

