/*
 * Decompiled with CFR 0.152.
 */
package com.saorsa.util;

public class BitVector {
    static final String CVS_ID = "$Id$";
    public static final int CHAR_SIZE = 7;
    private byte[] m_bytes;

    public BitVector(int p_size) {
        int size = p_size < 0 ? 0 : (p_size + 7) / 8;
        this.m_bytes = new byte[size];
    }

    public BitVector(byte[] p_byteArray) {
        int size;
        if (p_byteArray == null || (size = p_byteArray.length) == 0) {
            size = 0;
        }
        this.m_bytes = new byte[size];
        System.arraycopy(p_byteArray, 0, this.m_bytes, 0, size);
    }

    public byte[] getBytes() {
        return this.m_bytes;
    }

    public int getBit(int p_location) throws IndexOutOfBoundsException {
        return (this.m_bytes[this.byteIndex(p_location)] & 1 << this.bitIndex(p_location)) != 0 ? 1 : 0;
    }

    public void putBit(int p_location, int p_value) throws IndexOutOfBoundsException {
        int byteNum = this.byteIndex(p_location);
        int bitNum = this.bitIndex(p_location);
        this.m_bytes[byteNum] = (byte)(this.m_bytes[byteNum] & ~(1 << bitNum) | (p_value & 1) << bitNum);
    }

    public boolean getBoolean(int p_location) throws IndexOutOfBoundsException {
        return this.getBit(p_location) != 0;
    }

    public void putBoolean(int p_location, boolean p_value) throws IndexOutOfBoundsException {
        this.putBit(p_location, p_value ? 1 : 0);
    }

    public int getInt(int p_location, int p_length) throws IndexOutOfBoundsException {
        if (p_length <= 0 || p_location + p_length > this.m_bytes.length * 8) {
            throw new IndexOutOfBoundsException("BitVector length");
        }
        int acc = 0;
        int i = p_location + p_length - 1;
        while (i >= p_location) {
            acc <<= 1;
            acc |= this.getBit(i);
            --i;
        }
        return acc;
    }

    public void putInt(int p_location, int p_length, int p_value) throws IndexOutOfBoundsException {
        if (p_length <= 0 || p_location + p_length > this.m_bytes.length * 8) {
            throw new IndexOutOfBoundsException("BitVector length");
        }
        if (p_value < 0 || p_value >= (int)Math.pow(2.0, p_length)) {
            throw new IndexOutOfBoundsException("BitVector value");
        }
        int acc = p_value;
        int i = p_location;
        while (i < p_location + p_length) {
            this.putBit(i, acc & 1);
            acc >>= 1;
            ++i;
        }
    }

    public int getSignedInt(int p_location, int p_length) throws IndexOutOfBoundsException {
        return this.getInt(p_location + 1, p_length - 1) * (this.getBoolean(p_location) ? -1 : 1);
    }

    public void putSignedInt(int p_location, int p_length, int p_value) throws IndexOutOfBoundsException {
        this.putBoolean(p_location, p_value < 0);
        this.putInt(p_location + 1, p_length - 1, Math.abs(p_value));
    }

    public long getLong(int p_location, int p_length) throws IndexOutOfBoundsException {
        if (p_length <= 0 || p_location + p_length > this.m_bytes.length * 8) {
            throw new IndexOutOfBoundsException("BitVector length");
        }
        long acc = 0L;
        int i = p_location + p_length - 1;
        while (i >= p_location) {
            acc <<= 1;
            acc |= (long)this.getBit(i);
            --i;
        }
        return acc;
    }

    public void putLong(int p_location, int p_length, long p_value) throws IndexOutOfBoundsException {
        if (p_length <= 0 || p_location + p_length > this.m_bytes.length * 8) {
            throw new IndexOutOfBoundsException("BitVector length");
        }
        if (p_value < 0L || p_value >= (long)Math.pow(2.0, p_length)) {
            throw new IndexOutOfBoundsException("BitVector value");
        }
        long acc = p_value;
        int i = p_location;
        while (i < p_location + p_length) {
            this.putBit(i, (int)(acc & 1L));
            acc >>= 1;
            ++i;
        }
    }

    public long getSignedLong(int p_location, int p_length) throws IndexOutOfBoundsException {
        return this.getLong(p_location + 1, p_length - 1) * (this.getBoolean(p_location) ? -1L : 1L);
    }

    public void putSignedLong(int p_location, int p_length, long p_value) throws IndexOutOfBoundsException {
        this.putBoolean(p_location, p_value < 0L);
        this.putLong(p_location + 1, p_length - 1, Math.abs(p_value));
    }

    public char getChar(int p_location) throws IndexOutOfBoundsException {
        return (char)this.getInt(p_location, 7);
    }

    public void putChar(int p_location, char p_value) throws IndexOutOfBoundsException {
        this.putInt(p_location, 7, p_value & 0x7F);
    }

    public String getString(int p_location, int p_length) throws IndexOutOfBoundsException {
        StringBuffer buf = new StringBuffer();
        int limit = p_length * 7;
        int i = 0;
        while (i < limit) {
            buf.append(this.getChar(p_location + i));
            i += 7;
        }
        return buf.toString().trim();
    }

    public void putString(int p_location, int p_length, String p_value) throws IndexOutOfBoundsException {
        int i = 0;
        while (i < p_value.length() && i < p_length) {
            this.putChar(p_location, p_value.charAt(i++));
            p_location += 7;
        }
        while (i++ < p_length) {
            this.putChar(p_location, ' ');
            p_location += 7;
        }
    }

    public int size() {
        return this.m_bytes.length * 8;
    }

    protected int byteIndex(int p_location) throws IndexOutOfBoundsException {
        if (p_location < 0 || p_location >= this.m_bytes.length * 8) {
            throw new IndexOutOfBoundsException("BitVector location");
        }
        return p_location / 8;
    }

    protected int bitIndex(int p_location) throws IndexOutOfBoundsException {
        if (p_location < 0 || p_location >= this.m_bytes.length * 8) {
            throw new IndexOutOfBoundsException("BitVector location");
        }
        return p_location % 8;
    }
}

