/* funkcja.c - Listing 10.5 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

char *pobierz_imie(void); /* Prototyp funkcji. */

int main (void) {

  /* Zadeklaru zmienn wskanikow typu char,
   * aby przechowywaa adres bazowy tablicy
   * znakw, na przykad tekstu. */
  char *imie = NULL;

  /* Wywoaj funkcj i zapamitaj zwrcony przez ni
   * adres w zmiennej wskanikowej. */
  imie = pobierz_imie();

  /* Sprawd, czy pobranie si udao. */
  assert(imie != NULL);
  
  /* Wywietl imi. */
  printf("Wpisane imi to: %s.\n", imie);

  /* Zwr blok do puli */
  free(imie);
  imie = NULL;

  /* Zaczekaj na nacinicie klawisza Enter lub Return. */
  getchar();
  getchar();

  return 0;

} /* Koniec funkcji main(). */


/* Funkcja prosi o podanie imienia i zwraca
 * wskanik na tablic znakw z imieniem. */
char *pobierz_imie(void) {

  /* Alokuj blok pamici o rozmiarze 100 bajtw. */
  char *wejscie = malloc(100);
  
  /* Sprawd, czy alokacja si powioda. */
  if (wejscie == NULL) {
    printf("Nieudana alokacja pamici!\n");
    return NULL;
  }
  
  /* Popro o wpisanie imienia. */
  printf("Wpisz imi: ");

  /* Zapamitaj wejcie w bloku. */
  scanf("%99s", wejscie);
  
  /* Zwr adres bloku pamici. */
  return wejscie;

} /* Koniec funkcji pobierz_imie(). */
