/* zapis_binarny.c - Listing 12.5 */

#include <stdio.h>
#include <stdlib.h> /* Dla rand() i srand(). */
#include <time.h> /* Dla time() uywanej w srand(). */

/* Ustaw ciek i nazw pliku. */
#define PLIK "C:\\testy\\liczby.dat"

/* Liczba elementw do zapisania. */
#define ELEM 50

int main (void) {
	
  /* Potrzebujemy wskanika typu FILE. */
  FILE *fp;
	
  int i; /* Zmienna ptli. */
  int liczby[ELEM]; /* Tablica liczb. */
	
  /* Prba otwarcia pliku binarnego do zapisu. */
  fp = fopen(PLIK, "wb");
	
  if (fp != NULL) { /* Plik zosta otwarty. */
	
    /* Inicjalizacja ziarna. */
    srand((unsigned)time(NULL));
		
    /* Wypenienie tablicy liczbami losowymi mniejszymi od 100. */
    for (i = 0; i < ELEM; i++) {
      liczby[i] = rand() % 100;
    }
		
    /* Zapisz danych do pliku. */
    fwrite (liczby, sizeof(int), ELEM, fp);
    printf ("Dane zostay zapisane.\n");
		
  } else {
    printf ("Nie udao si otworzy pliku.\n");
    return 1; /* Wyjcie z funkcji i aplikacji. */
  }
	
  /* Zamknicie pliku. */
  if (fclose(fp) != 0) {
    printf ("Nie udao si zamkn pliku.\n");
  }

  getchar(); /* Pauza. */
  return 0;
}
