/* odczyt_temp.c - Listing 13.2 */

#include <stdio.h>

/* Ustaw ciek i nazw pliku. */
#define PLIK "C:\\testy\\pogoda.dat"

int main (void) {
	
  /* Zdefiniuj struktur. */
  struct rekord_temp {
    char data[11];
    int wysoka;
    int niska;
  };
	
  /* Uyj operatora typedef do utworzenia aliasu. */
  typedef struct rekord_temp rt;
	
  /* Utwrz zmienn bdc struktur. */
  rt dzien;
	
  /* Potrzebujemy wskanika typu FILE. */
  FILE *fp;

  /* Prba otwarcia pliku binarnego w trybie odczytu. */
  fp = fopen(PLIK, "rb");
	
  if (fp != NULL) { /* Plik zosta otwarty. */
		
    /* Przejd przez cay plik, przypisujc kad ze struktur do dzien. */
    while (fread (&dzien, sizeof (rt), 1, fp)) {
			
      /* Wywietl informacje, uywajc danych ze struktury. */
      printf ("Data: %s\nWysoka: %d\nNiska: %d\n\n", dzien.data, dzien.wysoka, dzien.niska);
			
    }
		
  } else {
    printf ("Nie udao si otworzy pliku.\n");
    return 1; /* Wyjcie z funkcji i aplikacji. */
  }
	
  /* Zamknicie pliku. */
  if (fclose(fp) != 0) {
    printf ("Nie udao si zamkn pliku.\n");
  }
	
  getchar(); /* Pauza. */
  return 0;

}
