/* zmiana_rozm.c - Listing 10.4 */

#include <stdio.h>
#include <stdlib.h>

/* Prototyp funkcji uywanej do sortowania wartoci. */
int sortowanie(const void *x, const void *y);

int main (void) {

  /* Deklaruje zmienn wskanikow typu int. */
  int *liczby;
  
  /* Deklaruje zmienn przechowujc liczb wpisan przez uytkiownika
   * i odczytan funkcj scanf(). Deklaruje drug zmienn do
   * przechowywania wyniku zwracanego przez funkcj scanf(). */
  int wejscie, wynik;
  
  /* Deklaruje zmienne typu int zawierajce aktualny rozmiar
   * dynamicznej tablicy, nastpny wolny indeks w tablicy i
   * licznik dla ptli for. */
  int rozmiar = 4, i, indeks = 0;

  /* Zaalokuj tablic o pocztkowym rozmiarze. */
  liczby = malloc(rozmiar * sizeof(int));
  
  /* Ponownie opuszczamy sprawdzanie wartoci NULL. */

  /* Pocztek ptli nieskoczonej, z ktrej wyjcie
   * nastpuje dopiero po wpisaniu liczby 0 lub litery. */
  while (1) {
    
    /* Popro uytkownika o liczb i odczytaj j funkcj scanf(). */
    printf("Wpisz niezerow liczb cakowit (lub 0, aby wyj): ");
    wynik = scanf("%d", &wejscie);

    /* Jeli wpisano 0 lub podano co innego od liczby,
     * opu ptl za pomoc instrukcji break. */
    if (wynik < 1 || wejscie == 0) break;

    /* Przed zapamitaniem wartoci w tablicy, sprawd, czy jest miejsce.
     * Jeli go nie ma, uyj funkcji realloc(), do powikszenia tablicy. */
    if (indeks == rozmiar) {
      rozmiar *= 1.5;
      liczby = realloc(liczby, rozmiar * sizeof(int));
      printf("Zmiana rozmiaru bloku. Aktualny rozmiar to %d bajtw.\n", rozmiar * sizeof(int));
    }

    /* Zapamitaj now warto w kolejnym wolnym elemencie. */
    liczby[indeks] = wejscie;
    
    /* Zwiksz indeks, aby wskazywa na kolejne wolne miejsce. */
    indeks++;

  } /* Koniec gwnej ptli. */


  /* Wyszlimy z nieskoczonej ptli. Uyjmy funkcji qsort(), aby
   * posortowa wartoci znajdujce si w tablicy w porzdku rosncym. */
  qsort(liczby, indeks, sizeof(int), sortowanie);


  /* Wywietl zawarto tablicy, uywajc ptli. */
  for (i = 0; i < indeks; i++) {
    printf("Element: %d --> Warto: %d.\n", i, liczby[i]);
  }

  /* Zwr blok do puli. */
  free(liczby);
  liczby = NULL;

  /* Zaczekaj na naciniecie klawisza Enter lub Return. */
  getchar();
  getchar();

  return 0;

} /* Koniec funkcji main(). */


/* Jest to funkcja porwnujca uywana przez
 * funkcj qsort() do sortowania wartoci.
 * Szczegw szukaj w dokumentacji standardowej
 * biblioteki jzyka C. */
int sortowanie(const void *x, const void *y) {

  const int *a = x, *b = y;

  if (*a < *b) {
    return -1;
  } else if (*a > *b) {
    return 1;
  }

  return 0;

} /* Koniec funkcji sortowanie(). */
