/* sortuj.c - Listing 11.6 - modyfikajca kopiowanie.c (listing 11.5) */

#include <stdio.h>
#include <string.h> /* Dla strncpy() i strcmp(). */

void wyczysc_wejscie (void); /* Prototyp funkcji. */

#define ILE_TEKSTOW 10
#define DL_TEKSTU 10

int main (void) {
  
  /* Zadeklaruj wielowymiarow tablic znakw. */
  char wyrazy[ILE_TEKSTOW][DL_TEKSTU];
  
  char wejscie[DL_TEKSTU]; /* Dane od uytkownika. */

  /* Wskaniki. */
  char *wyrazy_wsk[ILE_TEKSTOW];
  char *tymcz;
  
  int i,j; /* Zmienna ptli. */
  int ile = 0; /* Zlicza wpisane wyrazy. */
  
  /* Odczytaj maksymalnie ILE_TEKSTOW wyrazw. */
  for (i = 0; i < ILE_TEKSTOW; ++i) {
    
    /* Popro o wpisanie wyrazu i pobierz go z wejcia. */
    printf("Wpisz wyraz (lub 0, by wyj): ");
    scanf("%9s", wejscie);
    wyczysc_wejscie();
    
    /* Sprawd, czy wpisano 0. */
    if (wejscie[0] == '0') break;
    
    /* Skopiuj wejcie do tablicy. */
    strncpy(wyrazy[i], wejscie, DL_TEKSTU);
    
    /* Kopiuj adres do wskanika. */
    wyrazy_wsk[i] = &wyrazy[i][0];
    
    /* Zwiksz licznik wyrazw. */
    ++ile;
    
  } /* Koniec ptli. */
  
  printf("Wpisanio %d wyrazw.\n", ile);

  /* To jest sortowanie bbelkowe. */
  for (i = 0; i < (ile - 1); ++i) { /* Przejcie przez kay wyraz. */
    
    for (j = (i + 1); j < ile; ++j) { /* Ponowne przejcie przez kady wyraz. */
      
      if (strcasecmp(wyrazy_wsk[i],wyrazy_wsk[j]) > 0) { /* Porwnanie wyrazw. */
        
        tymcz = wyrazy_wsk[i]; /* Przenie pierwsze sowo do zm. tymczasowej. */
        wyrazy_wsk[i] = wyrazy_wsk[j]; /* Przypisz drugie sowo do pierwszego. */
        wyrazy_wsk[j] = tymcz; /* Przypisz zm. tymczasow (oryginalnie pierwsze sowo) do 2 sowa. */
        
      } /* Koniec IF. */

    } /* Koniec wewntrznego FOR. */

  } /* Koniec zewntrznego FOR. */
  
  printf("Kolejno wyrazw w porzdku alfabetycznym:\n");

  /* Wywietl wyrazy w ptli. */
  for (i = 0; i < ile; i++) {
    printf("%s\n", wyrazy_wsk[i]);
  }
  
  getchar();  
  return 0;
  
} /* Koniec funkcji main(). */

/* Funkcja czyci wejcie ze zbdnych znakw. */
void wyczysc_wejscie (void) {
  
  char smieci; // W celu pozbycia si nadmiarowych znakw.
  
  // Przejd przez wejcie i ignoruj nowe znaki.
  do {
    smieci = getchar();
  } while (smieci != '\n' );

} /* Koniec funkcji wyczysc_wejscie(). */
