// random.cpp - Listing 14.6

#include <iostream>
#include <string>

// Do obsugi plikw potrzebujemy
// pliku nagwkowego fstream.
#include <fstream>

// Zdefiniuj struktur.
struct car {

    char make[20];
    char model[20];
    unsigned short year;

}; // Nie zapomnij o redniku.

int main() {

    // Zdefiniuj obiekt pliku.
    std::ifstream fileInput("cars.dat", std::ios::binary);

    // Sprawd, czy plik udao si otworzy.
    if (fileInput.is_open()) {

        // Sprawd ile rekordw
        // znajduje si w pliku.
        unsigned long start, end;

        // Odczytaj pozycj pocztkow.
        start = fileInput.tellg();

        // Przesu wskanik na koniec pliku
        // i znw odczytaj pozycj.
        fileInput.seekg(0,std::ios::end);
        end = fileInput.tellg();

        // Oblicz liczb rekordw:
        // end - start = rozmiar pliku; podzielony
        // przez rozmiar rekordu da liczb rekordw.
        unsigned short num = (end - start)/sizeof(car);

        // Pobierz od uytkownika numer rekordu.
        unsigned short input;
        do {
            std::cout << "Podaj dowoln liczb od 0 do "
            << (num - 1) << ": ";
            std::cin >> input;
            std::cin.ignore(100, '\n');
        } while (input >= num); // Numer musi by mniejszy
                                // od liczby rekordw.

        // Wypisz nagwek.
        std::cout << "Wybrane auto to: ";

        // Przesu wskanik pozycji na wybrany rekord.
        fileInput.seekg((sizeof(car) * input));

        // Wczytaj rekord.
        car aCar;
        fileInput.read(reinterpret_cast<char *>(&aCar), sizeof(aCar));

        // Wypisz dane wybranego auta.
        std::cout << aCar.year
        << " " << aCar.make
        << " " << aCar.model << "\n";

        // Zamknij strumie plikowy.
        fileInput.close();

    } else { // Nie udao si otworzy pliku.
        std::cout << "Nie udao si otworzy pliku!\n";
        return 1; // Sygnalizacja wykrytego problemu.
        // Alternatyw byoby zrzucenie wyjtku.
    }

    std::cin.ignore(100, '\n');
    std::cout << "Nacinij Enter albo Return, aby kontynuowa.\n";
    std::cin.get();
    return 0;

} // Koniec funkcji main().
