// stack.cpp - Listing 13.2

#include <iostream>

#include <string>

// Utwrz szablon klasy.
template <class T>
class Stack {
public:
    // Konstruktor:
    Stack(unsigned int size = 100);
    
    // Destruktor:
    ~Stack();
    
    // Metody:
    void push(T value);
    T pop();

private:
    unsigned int size;
    unsigned int sp;
    T *data;

};

// Implementacja konstruktora.
template <class T>
Stack<T>::Stack(unsigned int size /* = 100 */) {
    this->size = size;
    data = new T[size];
    sp = 0;
}

// Implementacja destruktora.
template <class T>
Stack<T>::~Stack() {
    delete[] data;
}

// Implementacje metod.
template <class T>
void Stack<T>::push(T value) {
    data[sp++] = value;
}

template <class T>
T Stack<T>::pop() {
    return data[--sp];
}


int main() {

    // Utwrz nowy stos.
    Stack<int> intStack(100);
    
    // Wstaw na stos kilka elementw.
    intStack.push(1);
    intStack.push(2);
    intStack.push(3);

    // Zdejmij ze stosu kilka elementw.
    std::cout << "wywoanie intStack.pop() zwrcio " << intStack.pop() << "\n";
    std::cout << "wywoanie intStack.pop() zwrcio " << intStack.pop() << "\n";
    std::cout << "wywoanie intStack.pop() zwrcio " << intStack.pop() << "\n";

    std::cout << "Nacinij Enter albo Return, aby kontynuowa.";
    std::cin.get();
    return 0;
}
