// factorial2.cpp - Listing 10.3

#include <iostream>

// Potrzebujemy pliku climits aby
// pozna maksymalny rozmiar
// typu unsigned long int.
#include <climits>

// Prototyp funkcji.
// Funkcja pobiera jeden argument typu unsigned short int.
// Zwraca warto typu unsigned long int.
// Moe zrzuci wyjtek.
unsigned long returnFactorial(unsigned short num) throw (const char *);

// Pocztek funkcji main().
int main() {

    // Deklaracja zmiennej dla danych uytkownika.
    unsigned short numberIn = 0;
        
    // Pytanie uytkownika o argument silni, wczytanie
    // argumentu i sprawdzenie jego wartoci.
    std::cout << "Podaj niewielk dodatni liczb cakowit: [##] ";
    while (!(std::cin >> numberIn) || (numberIn < 1)) {

        // Problem! Wyzeruj strumie cin i sprbuj jeszcze raz.
        std::cin.clear();
        std::cin.ignore(100, '\n');
        std::cout << "Podaj niewielk dodatni liczb cakowit: [##] ";
        
    } // Koniec ptli while
    
    // Odrzu zbyteczne znaki wejcia.
    std::cin.ignore(100, '\n');
    
    // Sprbuj obliczy silni.
    try {
        
        unsigned long factorial = returnFactorial(numberIn);
        std::cout << "Silnia z " << numberIn
        << " wynosi " << factorial << ".\n\n";

    }

    // Przechwy ewentualny wyjtek.
    catch (const char *e) {
        std::cout << e;
    }
    
    std::cout << "Nacinij Enter albo Return, aby kontynuowa.\n";
    std::cin.get();
    return 0;
    
} // Koniec funkcji main().

// Definicja funkcji.
unsigned long returnFactorial(unsigned short num) throw (const char *) {

    // Na potrzeby oblicze.
    unsigned long sum = 1;
    
    // Maksymalna moliwa warto liczbowa.
    unsigned long max = ULONG_MAX;
    
    // Ptla od 1 do num.
    // Kumulowanie iloczynu silni.
    // Kumulowanie ilorazu kontrolnego.
    for (int i = num; i >= 1; --i) {
        
        sum *= i;
        max /= i;
        
    }  // Koniec ptli for.
    
    if (max < 1) { // Zrzu wyjtek.

        throw "Nie mona obliczy silni na tym komputerze.\nSprbuj ponownie dla mniejszego argumentu.\n\n";

    } else { // Zwr silni.
        return sum;
    }

} // Koniec funkcji returnFactorial().
