// virtualpets.cpp - Listing 9.2

#include <iostream>

#include <string>

// Deklaracja klasy.
class Pet {
public:

    // Konstruktor i destruktor.
    Pet(std::string theName);

    void eat();
    void sleep();
    void play();

protected:
    std::string name;

};

// Deklaracje klas dziedziczcych.
class Cat : public Pet {
public:
    Cat(std::string theName);

    void play();
    void climb();
};

class Dog: public Pet {
public:
    Dog(std::string theName);

    void play();
    void bark();
};


// Definicje metod.
Pet::Pet(std::string theName) {
    name = theName;
 
}


void Pet::sleep() {
    std::cout << name << " pi.\n";
}

void Pet::eat() {
    std::cout << name << " je.\n";
}
 
void Pet::play() {
    std::cout << name << " bawi si.\n";
}
 
Cat::Cat(std::string theName) : Pet(theName) {
}

void Cat::climb() {
    std::cout << name << " wspina si na drzewo.\n";
}

void Cat::play() {
    Pet::play();
    std::cout << name << " toczy kbek weny.\n";
}

Dog::Dog(std::string theName) : Pet(theName) {
}

void Dog::bark() {
    std::cout << name << "daje gos!\n";
}

void Dog::play() {
    Pet::play();
    std::cout << name << " goni kota.\n";
}


int main() {

    // Utwrz dwa egzemplarze klasy Pet: psa i kota.
    // Zapisz adresy tych egzemplarzy we wskanikach na Pet.
    Pet *cat = new Cat("Pluszak");
    Pet *dog = new Dog("Reks");

    // Niech kot si wypi, naje i pobawi:
    cat->sleep();
    cat->eat();
    cat->play();
    
    
    // Niech pies si wypi, naje i pobawi:
    dog->sleep();
    dog->eat();
    dog->play();
    
    // Nie potrzebujemy ju zwierzakw,
    // wic musimy je usun.
    delete cat;
    delete dog;
    
    std::cout << "Nacinij Enter lub Return, aby kontynuowa.\n";
    std::cin.get();
    return 0;
}
