// student.cpp - Listing 9.7

#include <iostream>

#include <string>

// Deklaracja klasy Person
class Person {
public:
    Person(std::string theName);
                
    void introduce();

protected:
    std::string name;
};

// Deklaracja klasy Teacher.
// Teacher dziedziczy po Person.
class Teacher : public Person {
public:
    Teacher(std::string theName, std::string theClass);

    void teach();
    void introduce();

protected:
    std::string clazz;
};

// Deklaracja klasy Student.
// Student dziedziczy po Person.
class Student : public Person {
public:
    Student(std::string theName, std::string theClass);

    void attendClass();
    void introduce();

protected:
    std::string clazz;
};

// Deklaracja klasy TeachingStudent.
// Klasa dziedziczy po klasach Student i Teacher.                              
class TeachingStudent : public Student, public Teacher {
public:

    // Konstruktor.
    TeachingStudent(std::string theName,
        std::string classTeaching,
        std::string classAttending);

    void introduce();
};


// Definicje metod.
Person::Person(std::string theName) {
    name = theName;
}

void Person::introduce() {
    std::cout << "Witam, nazywam si " << name << "\n";
}

Teacher::Teacher(std::string theName, std::string theClass)
: Person(theName) {
    clazz = theClass;
}

void Teacher::teach() {
    std::cout << name << " wykada ";
    std::cout << "'" << clazz << "'.\n";
}

void Teacher::introduce() {
    std::cout << "Witam, nazywam si " << name << " i bd wykada '" << clazz << "'.\n";
}

Student::Student(std::string theName, std::string theClass)
: Person(theName) {
    clazz = theClass;
}

void Student::attendClass() {
    std::cout << name << " studiuje ";
    std::cout << "'" << clazz << "'.\n";
}

void Student::introduce() {
    std::cout << "Dzie dobry, nazywam si " << name << " i studiuj '" << clazz << "'.\n";
}
    
// Konstruktor klasy TeachingStudent musi wywoa
// konstruktory wszystkich klas bazowych!
TeachingStudent::TeachingStudent(
    std::string theName,
    std::string classTeaching,
    std::string classAttending)
: Teacher(theName, classTeaching),
  Student(theName, classAttending)
{
}
                       
void TeachingStudent::introduce() {
    // Poniewa TeachingStudent dziedziczy dwie kopie
    // atrybutw klasy Person (jedn z klasy Teacher
    // i drug z klasy Student) trzeba podpowiedzie
    // kompilatorowi, ktrej kopii ma uy.
    std::cout << "Witam, nazywam si " << Student::name << ". Wykadam '" << Teacher::clazz << "' ";
    std::cout << "i studiuj '" << Student::clazz << "'.\n";
}

    
int main() {


    // Utwrz obiekty.
    Teacher teacher("Kowalski", "Podstawy C++");
    Student student("Nowak", "Podstawy C++");
    TeachingStudent teachingStudent("Winiewski", "Podstawy C++", "Zaawansowane programowanie w C++");

    // Niech zajm si swoimi obowizkami.
    teacher.introduce();
    teacher.teach();
    student.introduce();
    student.attendClass();
    teachingStudent.introduce();
    teachingStudent.teach();
    teachingStudent.attendClass();
    
    std::cout << "Nacinij Enter lub Return, aby kontynuowa.\n";
    std::cin.get();
    return 0;
}
