// pets2.cpp - Listing 8.3

// Potrzebujemy pliku iostream, by mc
// korzysta z cin i cout.
#include <iostream>

// Potrzebujemy pliku string, by mc
// operowa acuchami znakw.
#include <string>

// Deklaracja klasy Pet.
class Pet {    
public:

    // Konstruktor:
    Pet(std::string theName);
    
    // Metody.
    void eat();
    void sleep();    
    
protected:
    std::string name;
    
};

// Deklaracja podklasy Cat.
class Cat : public Pet {
public:

    // Konstruktor:
    Cat(std::string theName);
    
    void climb();
    
};

// Deklaracja kolejnej klasy pochodnej.
class Dog : public Pet {
public:

    // Konstruktor:
    Dog(std::string theName);
    
    void bark();
    
};


// Definicje funkcji:
Pet::Pet(std::string theName) {
    name = theName;
}

void Pet::sleep() {
    std::cout << name << " pi.\n";
}

void Pet::eat() {
    std::cout << name << " je.\n";
}

// Konstruktor klasy Cat.
Cat::Cat(std::string theName) : Pet(theName) {
}

void Cat::climb() {
    std::cout << name << " wspina si na drzewo.\n";
}

// Konstruktor klasy Dog.
Dog::Dog(std::string theName) : Pet(theName) {
}

void Dog::bark() {
    std::cout << name << " robi 'hau-hau'.\n";
}

// Pocztek funkcji main().
int main() {

    // Utworzenie kota i psa.
    Cat cat("Garfield");
    Dog dog("Odie");
        
    // Zwierzta zajmuj si sob.
    cat.sleep();
    cat.eat();
    cat.climb();
        
    dog.sleep();
    dog.eat();
    dog.bark();
        
    // Zakoczenie programu.
    std::cout << "Nacinij Enter lub Return, aby kontynuowa.";
    std::cin.get();
    return 0;

} // Koniec funkcji main().
