// rectangle4.cpp - Listing 7.4

// Potrzebujemy pliku iostream, by mc
// korzysta z cout i cin
#include <iostream>

// Deklaracja klasy.
class Rectangle {

public:
	
	// Deklaracja atrybutw.
	unsigned width, height;

	// Konstruktor:
	Rectangle(unsigned width =0, unsigned height = 0);

	// Deklaracja metod.
	void setSize(unsigned width, unsigned height);
	unsigned area();
	unsigned perimeter();
	bool isSquare();

}; // Nie zapominajmy o redniku!

// Definicja konstruktora.
Rectangle::Rectangle(unsigned x, unsigned y) {
	width = x;
	height = y;
}

// Definicja metod klasy Rectangle.

/* Metoda setSize() przypisuje wymiary 
 * prostokta do atrybutw.
 * Przyjmuje dwa argumenty, oba to liczby cakowite bez znaku.
 * Nie zwraca nic.
 */
void Rectangle::setSize(unsigned x, unsigned y) {
	width = x;
	height = y;
}

/* Metoda area() zwraca 
 * pole prostokta.
 * Przyjmuje dwa argumenty, oba typu zmiennoprzecinkowego.
 * Zwraca liczb zmiennoprzecinkow.
 */
unsigned Rectangle::area() {
	return (width * height);
}

/* Metoda perimeter() zwraca 
 * obwd prostokta.
 * Przyjmuje dwa argumenty, oba to liczby cakowite bez znaku.
 * Zwraca liczb cakowit bez znaku.
 */
unsigned Rectangle::perimeter() {
	return (width + width + height + height);
}

/* Metoda isSquare() zwraca warto logiczn
 * wskazujc, czy prostokt jest take kwadratem.
 * Przyjmuje dwa argumenty, oba to
 * liczby cakowite bez znaku.
 * Zwraca warto typu logicznego.
 */
bool Rectangle::isSquare() {

	if (width == height) {
		return true; // Kwadrat.
	} else {
		return false; // Nie kwadrat.
	}

}


// Pocztek funkcji main()
int main() {

	// Utworzenie zmiennych.
	unsigned width = 25;
	unsigned height = 14;

	// Wypisanie wymiarw prostokta.
	std::cout << "O szerokoci " << width 
	<< " i wysokoci " << height << "...\n\n";
	
	// Utworzenie nowego obiektu i przypisanie wartoci
	Rectangle myRectangle(width, height);
	/* Alternatywa dla:
	 * Rectangle myRectangle;
	 * myRectangle.setsize(width, height);
	 */
	
	// Wypisanie pola.
	std::cout << "Pole prostokta wynosi "
	<< myRectangle.area() << ".\n";

	// Wypisanie obwodu.
	std::cout << "Obwd prostokta wynosi "
	<< myRectangle.perimeter() << ".\n";

	// Czy jest to kwadrat?
	std::cout << "Ten prostokt ";
	if (myRectangle.isSquare()) {
		std::cout << "jest take";
	} else {
		std::cout << "nie jest";
	}
	std::cout << " kwadratem. \n\n";

	// Oczekiwanie, a uytkownik nacinie Enter lub Return.
	std::cout << "Nacinij Enter lub Return, aby kontynuowa.\n";
	std::cin.get();

	// Zwrcenie warto 0, by zaznaczy brak problemw.
	return 0;

} // Koniec funkcji main().
