// mortgage5.cpp - Script 3.5

// Potrzebujemy pliku iostream, by mc
// korzysta z cin i cout.
#include <iostream>

// Potrzebujemy pliku cmath, by mc
// korzysta z funkcji pow().
#include <cmath>

// Pocztek funkcji main().
int main() {

    // Utworzenie zmiennych.
    unsigned long loanAmount = 150000; // Wysoko kredytu.
    float annualInterestRate = 6.0; // 6% oprocentowania.
    unsigned short loanLength = 30; // 30 lat okresu spaty.
    const unsigned short MONTHS_IN_YEAR = 12; 
    bool approved = false; // Kredyt nieprzyznany.
     
    // Zadeklaruj stae.
    const unsigned short LOW_MAX = 200;
    const unsigned short MODERATE_MAX = 1000;
    const unsigned short PRICEY_MAX = 2000;
    const unsigned short EXPENSIVE_MAX = 5000;

    // Podstawowe obliczenia.
    float monthlyInterestRate = annualInterestRate / MONTHS_IN_YEAR; // Oprocentowanie miesiczne.
    monthlyInterestRate = monthlyInterestRate/100; // Oprocentowanie miesiczne w procentach.
    unsigned short numberPayments = loanLength * MONTHS_IN_YEAR;  

    // Obliczanie rat hipotecznych podzielone na mniejsze etapy.
    float monthlyPayment = 1 - pow((1 + monthlyInterestRate), -numberPayments);
    monthlyPayment = monthlyInterestRate/monthlyPayment;
    monthlyPayment = loanAmount * monthlyPayment;

    // Wypisanie informacji.
    std::cout << "Jeli bierzesz kredyt o wartoci " << loanAmount
    << "z przy oprocentowaniu rwnym " << annualInterestRate
    << "% na okres " << loanLength
    << " lat, jego miesiczna rata wynosi " ;
        
    // Ustawianie formatowania.
    std::cout.setf(std::ios_base::fixed);
    std::cout.setf(std::ios_base::showpoint);
    std::cout.precision(2);
    
    // Wypisanie wysokoci rat.
    std::cout << monthlyPayment << "z.\n\n";
    
    // Jak drogie s raty miesiczne?
    if (monthlyPayment < LOW_MAX) {
        std::cout << "Wysoko rat jest miesznie maa!\n\n";
    } else if (monthlyPayment < MODERATE_MAX) {
        std::cout << "Wysoko rat wydaje si rozsdna.\n\n";
    } else if (monthlyPayment < PRICEY_MAX) {
        std::cout << "Trzeba bdzie zacisn pasa!\n\n";
    } else if (monthlyPayment < EXPENSIVE_MAX) {
        std::cout << "Ojojoj!\n\n";
    } else {
        std::cout << "Miejmy nadziej, e nazywasz si 'Rockefeller'!\n\n";
    }
    
    // Czy kredyt zosta przyznany?
    std::cout << "Po zweryfikowaniu informacji kredyt ";
    std::cout << ((approved) ? "zosta" : "NIE zosta");
    std::cout << " przyznany.\n";
	
    // Wskazanie uytkownikowi, co ma robi.
    std::cout << "Nacinij Enter lub Return, aby kontynuowa.\n";
    
    // Oczekiwanie, a uytkownik nacinie Enter lub Return.
    std::cin.get();
    
    // Zwrcenie wartoci 0, by zaznaczy brak problemw.
    return 0;
    
} // Koniec funkcji main().
