// Rational.h - Listing 12.1

// Andi Signer i Larry Ullman.

// Plik deklaruje klas Rational.
// Klasa suy do reprezentowania
// liczb wymiernych (uamkw).

// Sprawd czy plik by ju
// wczany do kompilacji
#ifndef RATIONAL_H


// Jeli staa nie jest zdefiniowana,
// trzeba j zdefiniowa teraz.
#define RATIONAL_H


// Potrzebujemy pliku iostream dla
// odwoa do strumienia ostream.
#include <iostream>

// Deklaracja przestrzeni nazw.
namespace myMath {

// Deklaracja klasy.
class Rational {

public:

    // Konstruktor.
    Rational(int num, int denom);

    // Przecione metody implementujce
    // funkcje arytmetyczne:
    Rational operator+(Rational rhs);
    Rational operator-(Rational rhs);
    Rational operator*(Rational rhs);
    Rational operator/(Rational rhs);

private:

    // Metoda normalize() zadba o
    // przeksztacenie licznika i
    // mianownika do waciwej postaci.
    void normalize();

    // Atrybuty:
    int numerator;
    int denominator;

    // Funkcja operator<< bdzie odwoywaa si
    // do licznika i mianownika,
    // wic oznaczamy j jako zaprzyjanion.
    friend std::ostream& operator<<(std::ostream& os, Rational f);
    
};

} // Koniec przestrzeni nazw.

#endif // Koniec dyrektywy #ifndef RATIONAL_H
