// company.cpp - Listing 11.2

#include <iostream>

#include <string>

// Zadeklaruj klas Company (firma).
class Company {
public:

    // Konstruktor.
    Company(std::string name);
    
    // Wypisz informacje o firmie.
    virtual void printInfo();

protected:
    std::string name;
};

// Zadeklaruj klas Publisher (wydawnictwo).
// Publisher dziedziczy po Company.
class Publisher : public Company {
public:
    Publisher(std::string name, int booksPublished);

    virtual void printInfo();

private:
    int booksPublished;
};

// Implementacje metod.
Company::Company(std::string name) {
    this->name = name;
}

void Company::printInfo() {
    std::cout << "To jest firma o nazwie '" << name << "'.\n";
}

Publisher::Publisher(std::string name, int booksPublished) : Company(name) {
    this->booksPublished = booksPublished;
}

void Publisher::printInfo() {
    std::cout << "To jest wydawnictwo o nazwie '" << name << "'; wydao " << booksPublished << " ksiek.\n";
}


int main() {
    
    // Utwrz obiekt firmy w pamici dynamicznej.
    Company *company = new Company("Monopol");
    
    // Wypisz informacje o firmie.
    company->printInfo();
    
    // Zwolnij obiekt firmy.
    delete company;
    company = NULL;
    
    // Utwrz obiekt wydawcy.
    company = new Publisher("Powielacz", 99999);
    
    // Wypisz informacje o firmie.
    company->printInfo();
    
    // Usu obiekt firmy.
    delete company;
    company = NULL;
    
    std::cout << "Nacinij Enter albo Return, aby kontynuowa.\n";
    std::cin.get();
    return 0;
}
