// quote.cpp - listing 10.2

#include <iostream>

#include <string>

#include <fstream>

// Deklaracja klasy.
class StoreQuote {

public:
    // Konstruktor.
    StoreQuote(std::string filename);

    // Destruktor.
    ~StoreQuote();

    // Deklaracja metod.
    void inputQuote();
    void inputSpeaker();
    bool write();

private:
    // Deklaracja atrybutw.
    std::string quote, speaker;
  
    // Definicja obiektu plikowego.
    std::ofstream fileOutput;


}; // Nie zapominajmy o redniku!


// Definicja konstruktora.
// Konstruktor otwiera plik.
StoreQuote::StoreQuote(std::string filename) {

    std::cout << "W konstruktorze; otwieranie pliku.\n";

    fileOutput.open(filename.c_str(), std::ios::app);
    
    // Zakadamy, e plik udao si otworzy.
    assert(fileOutput.is_open());
    
    std::cout << "Jeli wida ten komunikat, plik udao si otworzy.\n";

}

// Definicja destruktora.
// Destruktor zamyka plik.
StoreQuote::~StoreQuote() {

    std::cout << "W destruktorze; zamykanie pliku.\n";
    
    fileOutput.close();
    
}

// Definicja metod klasy Quote.

/* Metoda inputQuote przypisuje
* cytat atrybutowi quote.
* Nie pobiera argumentw.
* Nie zwraca adnej wartoci.
*/
void StoreQuote::inputQuote() {

    std::getline(std::cin, quote);
    
    std::cout << "W inputQuote(); cytat brzmi: '"
    << quote << "'\n";
    
}

/* Metoda inputSpeaker przypisuje
* autora atrybutowi speaker.
* Nie pobiera argumentw.
* Nie zwraca adnej wartoci.
*/
void StoreQuote::inputSpeaker() {
    std::getline(std::cin, speaker);

    std::cout << "W inputSpeaker(); autorem jest '"
    << speaker << "'\n";
    
}

/* Metoda write() zwraca warto
* logiczn wskazujc, czy dane zostay
* zapisane do pliku czy te nie.
* Nie pobiera argumentw.
* Nie zwraca adnej wartoci.
*/
bool StoreQuote::write() {

    std::cout << "We write().\n";
  
    if (fileOutput.is_open()) {

        std::cout << "W metodzie write(); plik otwarty.\n";
   
        // Zapisz dane do pliku.
        fileOutput << quote << "|"
        << speaker << "\n";
        return true;
    } else { // Nie mona otworzy pliku.

        std::cout << "W metodzie write(); nie udao si otworzy pliku.\n";

        return false; // Wskazuje, e wystpi problem.
    }
}


int main() {

    // Stwrz nowy obiekt.
    StoreQuote quote("cytaty.txt");

    // Zapytaj o cytat i wczytaj wejcie.
    std::cout << "Podaj cytat (bez cudzysowu):\n";
    quote.inputQuote();

    // Zapytaj o autora cytatu i wczytaj wejcie.
    std::cout << "Podaj osob, ktrej przypisuje si cytat:\n";
    quote.inputSpeaker();

    // Zapisz dane.
    if (quote.write() ) {

        // Wypisz komunikat.
        std::cout << "Dane zostay zapisane do pliku!\n";

    } else { // Nie mona otworzy pliku.
        std::cout << "Dane nie mogy zosta zapisane!\n";
        return 1; // Wskazuje, e wystpi problem.
    }

    std::cout << "Nacinij Enter lub Return, aby kontynuowa.\n";
    std::cin.get();
    return 0;

}
