// factorial.cpp - Listing 10.1

#include <iostream>

// Potrzebujemy pliku climits aby
// pozna maksymalny rozmiar
// typu unsigned long int.
#include <climits>

// Deklaracja klasy.
class Factorial {
public:
    Factorial(unsigned short num = 1);
    bool inRange();
    unsigned long getFactorial();

private:
    unsigned short num;

}; // Koniec klasy.

// Implementacja metod:
Factorial::Factorial(unsigned short num) {
    this->num = num;
}

bool Factorial::inRange() {

    // Maksymalna moliwa warto.
    unsigned long max = ULONG_MAX;
    
    // Ptla od 1 do num, dzielenie
    // od maksymalnej wartoci.
    for (int i = num; i >= 1; --i) {
        
        max /= i;
        
    }  // Koniec ptli for.
    
    // Zwr warto logiczn ("prawda"/"fasz").
    if (max < 1) {
        return false;
    } else {
        return true;
    }

} // Koniec metody inRange().

unsigned long Factorial::getFactorial() {

    // Na start silni.
    unsigned long sum = 1;
    
    // Ptla od 1 do num,
    // z dodawaniem wyniku do sumy.
    for (int i = 1; i <= num; ++i) {
    
        // Pomn biec sum przez i.
        sum *= i;

    } // Koniec ptli for.
    
    return sum;
    
} // Koniec metody returnFactorial().

// Pocztek funkcji main().
int main() {

    // Deklaracja zmiennej dla danych uytkownika.
    unsigned short numberIn = 0;
        
    // Pytanie uytkownika o argument silni, wczytanie
    // argumentu i sprawdzenie jego wartoci.
    std::cout << "Podaj niewielk dodatni liczb cakowit: [##] ";
    while (!(std::cin >> numberIn) || (numberIn < 1)) {

        // Problem! Wyzeruj strumie cin i sprbuj jeszcze raz.
        std::cin.clear();
        std::cin.ignore(100, '\n');
        std::cout << "Podaj niewielk dodatni liczb cakowit: [##] ";
        
    } // Koniec ptli while
    
    // Odrzu zbyteczne znaki wejcia.
    std::cin.ignore(100, '\n');
    
    // Utwrz obiekt.
    Factorial f(numberIn);
    
    // Wypisz wynik.
    if (f.inRange()) {

      std::cout << "Silnia z " << numberIn << " wynosi " << f.getFactorial() << ".\n\n";

    } else {

        std::cout << "Silnia z " << numberIn
        << " nie moe by obliczona na tym komputerze.\n"
        << " Sprbuj ponownie z mniejsz wartoci argumentu.\n\n";

    }
    
    std::cout << "Nacinij Enter albo Return, aby kontynuowa.\n";
    std::cin.get();
    return 0;
    
} // Koniec funkcji main().
