// rational.cpp - Listing 9.5

#include <iostream>

#include <string>

// Deklaracja klasy.
class Rational {
public:

    // Konstruktor.
    Rational(int num, int denom);

    // Przecione metody implementujce
    // funkcje arytmetyczne:
    Rational operator+(Rational rhs);
    Rational operator-(Rational rhs);
    Rational operator*(Rational rhs);
    Rational operator/(Rational rhs);

    void print();

private:
    // Metoda normalize() zadba o przeksztacenie
    // licznika i mianownika do waciwej postaci.
    void normalize();

    int numerator;
    int denominator;
};


// Definicja konstruktora.
Rational::Rational(int num, int denom) {

    // Przypisanie wartoci.
    numerator = num;
    denominator = denom;

    // Wywoanie metody normalize() na wypadek
    // przekazania wartoci nieznormalizowanych
    normalize();
}

// Przecienia operatorw.
Rational Rational::operator+(Rational rhs) {

    // a   c   a*d   c*b   a*d + c*b
    // - + - = --- + --- = ---------
    // b   d   b*d   b*d      b*d

    int a = numerator;
    int b = denominator;
    int c = rhs.numerator;
    int d = rhs.denominator;
    
    // Oblicz nowyliczniki i mianownik
    int e = a*d + c*b;
    int f = b*d;
    
    // Zwr wynikowy obiekt Rational
    return Rational(e, f);
}

Rational Rational::operator-(Rational rhs) {

    // a   c   a   -c
    // - - - = - + ---
    // b   d   b    d

    // Zmie znak prawego operandu
    rhs.numerator = -rhs.numerator;

    // I zwyczajnie dodaj za pomoc operatora +
    return operator+(rhs); 
}

Rational Rational::operator*(Rational rhs) {

    // a   c   a*c
    // - * - = ---
    // b   d   b*d

    int a = numerator;
    int b = denominator;
    int c = rhs.numerator;
    int d = rhs.denominator;
    
    // Oblicz nowyliczniki i mianownik
    int e = a*c;
    int f = b*d;
    
    // Zwr wynikowy obiekt Rational
    return Rational(e, f);
}

Rational Rational::operator/(Rational rhs) {

    // a   c   a   d
    // - / - = - * -
    // b   d   b   c

    // Odwr prawy operator
    int t = rhs.numerator;
    rhs.numerator = rhs.denominator;
    rhs.denominator = t;
    
    // I zwyczajnie pomn za pomoc operatora *
    return operator*(rhs); 
}


// Definicje metod.
void Rational::print() {
    std::cout << numerator << "/" << denominator;
}

void Rational::normalize() {

    // Sprawd znaki.
    if (denominator < 0) {
        // Przenie znak do mianownika.
        numerator = -numerator;
        denominator = -denominator;
    }

    // Oblicz najwikszy wsplny dzielnik a/b
    // algorytmem Euklidesa
    int a = abs(numerator);
    int b = abs(denominator);
    while (b > 0) {
        int t = a % b;
        a = b;
        b = t;
    }
    
    // Podziel obie liczby przez a.
    numerator /= a;
    denominator /= a;
}


int main() {

    // Utwrz dwie liczby wymierne: 2/16 i 7/8.
    Rational f1(15, 25);
    Rational f2(7, 16);
    
    // Sprawdzian dodawania.
    Rational res = f1 + f2;
    f1.print();
    std::cout << " + ";
    f2.print();
    std::cout << " == ";
    res.print();
    std::cout << "\n";
    
    // Sprawdzian odejmowania.
    res = f1 - f2;
    f1.print();
    std::cout << " - ";
    f2.print();
    std::cout << " == ";
    res.print();
    std::cout << "\n";
    
    // Sprawdzian mnoenia.
    res = f1 * f2;
    f1.print();
    std::cout << " * ";
    f2.print();
    std::cout << " == ";
    res.print();
    std::cout << "\n";
    
    // Sprawdzian dzielenia.
    res = f1 / f2;
    f1.print();
    std::cout << " / ";
    f2.print();
    std::cout << " == ";
    res.print();
    std::cout << "\n";
    
    std::cout << "Nacinij Enter lub Return, aby kontynuowa.\n";
    std::cin.get();
    return 0;
}
