// petcount.cpp - Listing 9.1

#include <iostream>

#include <string>

// Deklaracja klasy.
class Pet {
public:

    // Konstruktor i festruktor.
    Pet(std::string theName);
    ~Pet();

    void eat();
    void sleep();

    // Statyczna metoda zwracajca
    // biec warto skadowej count:
    static int getCount();

protected:
    std::string name;

private:
    // Atrybut count bdzie zawiera liczb zwierzakw
    static int count;
};

// Deklaracje klas dziedziczcych.
class Cat : public Pet {
public:
    Cat(std::string theName);
    void climb();
};

class Dog: public Pet {
public:
    Dog(std::string theName);
    void bark();
};

// Przydziel miejsce dla zmiennej statycznej.
int Pet::count = 0;

// Definicje metod.
Pet::Pet(std::string theName) {
    name = theName;
 
    // Utworzono nowego zwierzaka, wic trzeba zwikszy licznik.
    count++;
 
    std::cout << "Tworzenie obiektu zwierzaka z imieniem '" << name <<"'.\n";
}

Pet::~Pet() {
    // Destruktor jest wywoywany przy usuwaniu obiektu;
    // trzeba wtedy zmniejszy licznik.
    count--;
    std::cout << "Usuwanie zwierzaka o imieniu '" << name <<"'.\n";
}

int Pet::getCount() {
    return count;
}

void Pet::sleep() {
    std::cout << name << "pi.\n";
}

void Pet::eat() {
    std::cout << name << "je.\n";
}
 
 
Cat::Cat(std::string theName) : Pet(theName) {
}

void Cat::climb() {
    std::cout << name << "wspina si na drzewo.\n";
}

Dog::Dog(std::string theName) : Pet(theName) {
}

void Dog::bark() {
    std::cout << name << "daje gos!\n";
}


int main() {

    // Utwrz dwa obiekty.
    Cat cat("Pluszak");
    Dog dog("Reks");

    // Wypisz biecy licznik zwierzakw.
    std::cout << "Posiadasz " << Pet::getCount() << " zwierzaki.\n";

    // Utwrz kolejny obiekt w osobnym bloku kodu:
    {
       Cat anotherCat("Gerard");
//       std::cout << "Teraz posiadasz " << anotherCat.getCount() << " zwierzaki\n";
        // Koniec zasigu obiektu anotherCat;
        // Kompilator wywoa destruktor anotherCat.
    }

    // Powtrz liczenie.
//    std::cout << "I znw posiadasz " << Pet::getCount() << " zwierzaki\n";
 
    std::cout << "Nacinij Enter lub Return, aby kontynuowa.\n";
    std::cin.get();
    return 0;
}
