// abstractpets.cpp - Listing 9.4

#include <iostream>

#include <string>

// Deklaracja klasy.
class Pet {
public:

    // Konstruktor i destruktor.
    Pet(std::string theName);

    virtual void eat();
    virtual void sleep();

    // Uzupenienie prototypu zapisem = 0 informuje kompilator,
    // e ma do czynienia z metod abstrakcyjn
    virtual void play() =0;

protected:
    std::string name;

};

// Deklaracje klas dziedziczcych.
class Cat : public Pet {
public:
    Cat(std::string theName);

    // Aby dao si tworzy obiekty Cat
    // trzeba przesoni metod play()!
    void play();
    void climb();
};

class Dog: public Pet {
public:
    Dog(std::string theName);

    // Aby dao si tworzy obiekty Dog
    // trzeba przesoni metod play()!
    void play();
    void bark();
};


// Definicje metod.
Pet::Pet(std::string theName) {
    name = theName;
 
}

void Pet::sleep() {
    std::cout << name << " pi.\n";
}

void Pet::eat() {
    std::cout << name << " je.\n";
}
  
Cat::Cat(std::string theName) : Pet(theName) {
    // Poza przekazaniem imienia do konstruktora
    // klasy Pet nie ma tu nic do roboty.
}

void Cat::climb() {
    std::cout << name << " wspina si na drzewo.\n";
}

void Cat::play() {
    std::cout << name << " toczy kbek weny.\n";
}

Dog::Dog(std::string theName) : Pet(theName) {
    // Poza przekazaniem imienia do konstruktora
    // klasy Pet nie ma tu nic do roboty.
}

void Dog::bark() {
    std::cout << name << "daje gos!\n";
}

void Dog::play() {
    std::cout << name << " goni kota.\n";
}


int main() {

    // Utwrz dwa egzemplarze klasy Pet: psa i kota.
    // Zapisz adresy tych egzemplarzy we wskanikach na Pet.
    Pet *cat = new Cat("Pluszak");
    Pet *dog = new Dog("Reks");

    // Niech kot si wypi, naje i pobawi:
    cat->sleep();
    cat->eat();
    cat->play();
    
    
    // Niech pies si wypi, naje i pobawi:
    dog->sleep();
    dog->eat();
    dog->play();
    
    // Nie potrzebujemy ju zwierzakw,
    // wic musimy je usun.
    delete cat;
    delete dog;
    
    std::cout << "Nacinij Enter lub Return, aby kontynuowa.\n";
    std::cin.get();
    return 0;
}
