// pets4.cpp - Listing 8.5

// Potrzebujemy pliku iostream, by mc
// korzysta z cin i cout.
#include <iostream>

// Potrzebujemy pliku string, by mc
// operowa acuchami znakw.
#include <string>

// Deklaracja klasy Pet.
class Pet {    
public:
    Pet(std::string theName);
    void eat();
    void sleep();
    void play();
    
protected:
    std::string name;

};

// Deklaracja podklasy Cat.
class Cat : public Pet {
public:
    Cat(std::string theName);
    void play();
    void climb();
};

// Deklaracja kolejnej klasy pochodnej.
class Dog : public Pet {
public:
    Dog(std::string theName);
    void play();
    void bark();
    
    // Przeciona metoda:
    void bark(int count);
    
};


   // Definicje funkcji:
Pet::Pet(std::string theName) {
    name = theName;
}

void Pet::sleep() {
    std::cout << name << " pi.\n";
}

void Pet::eat() {
    std::cout << name << " je.\n";
}

void Pet::play() {
    std::cout << name << " bawi si.\n";
}

// Konstruktor klasy Cat.
Cat::Cat(std::string theName) : Pet(theName) {
}

void Cat::climb() {
    std::cout << name << " wspina si na drzewo.\n";
}

// Przesonicie metody:
void Cat::play() {
    Pet::play();
    std::cout << name << " poluje na kbek weny.\n";
}

// Konstruktor klasy Dog.
Dog::Dog(std::string theName) : Pet(theName) {
}

void Dog::bark() {
    std::cout << name << " robi 'hau-hau'.\n";
}

// Przesonicie metody:
void Dog::play() {
    Pet::play();
    std::cout << name << " apie koty.\n";
}

// Przecienie metody:
void Dog::bark(int count) {
    std::cout << name << " szczeka " << count << " razy.\n";
}
    
// Pocztek funkcji main().
int main() {

    // Utworzenie kota i psa.
    Cat cat("Garfield");
    Dog dog("Odie");
        
    // Zwierzta zajmuj si sob.
    cat.sleep();
    cat.eat();
    cat.climb();
    cat.play();
        
    dog.sleep();
    dog.eat();
    dog.bark();
    dog.play();
    dog.bark(15);
        
    std::cout << "Nacinij Enter lub Return, aby kontynuowa.";
    std::cin.get();
    return 0;
    
} // Koniec funkcji main().
