// petrenamer.cpp - Listing 8.6

// Potrzebujemy pliku iostream, by mc
// korzysta z cin i cout.
#include <iostream>

// Potrzebujemy pliku string, by mc
// operowa acuchami znakw.
#include <string>

// Deklaracja klasy Pet.
class Pet {    
public:
    Pet(std::string theName);
    
    void eat();
    void sleep();    
    
protected:
    std::string name;
    
    // Deklaracja przyjani:
    friend class PetRenamer;
};

// Deklaracja podklasy Cat.
class Cat : public Pet {
public:
    Cat(std::string theName);
    void climb();
};

// Deklaracja kolejnej klasy pochodnej.
class Dog : public Pet {
public:
    Dog(std::string theName);    
    void bark();
};

// Definicja klasy PetRenamer.
// Klasa ta NIE dziedziczy po Pet.
class PetRenamer {
public:

    // Konstruktor:
    PetRenamer(std::string theName);

    // Metoda zmieniajca imi.
    // Wymaga przekazania wskanika do zwierzcia
	// i jego nowego imienia.
    void rename(Pet *pet, std::string newName);
    
private: 
    std::string name;
};

// Konstruktor klasy PetRenamer:
PetRenamer::PetRenamer(std::string theName) {
    name = theName;
}

// Metoda rename() klasy PetRenamer:
void PetRenamer::rename(Pet *pet, std::string newName) {

    // Informacja, co si dzieje.
    std::cout << name << " zmieni imi ";
    
    // Wypisanie aktualnego imienia zwierzcia.
    std::cout << pet->name;
    
    // Wypisanie nowego imienia zwierzcia.
    std::cout << " na " << newName  << ".\n";
    
    // Zamiana imienia zwierzcia.
    pet->name = newName;
    
}


Pet::Pet(std::string theName) {
    name = theName;
}

void Pet::sleep() {
    std::cout << name << " pi.\n";
}

void Pet::eat() {
    std::cout << name << " je.\n";
}

// Konstruktor klasy Cat.
Cat::Cat(std::string theName) : Pet(theName) {
}

void Cat::climb() {
    std::cout << name << " wspina si na drzewo.\n";
}

// Konstruktor klasy Dog.
Dog::Dog(std::string theName) : Pet(theName) {
}

void Dog::bark() {
    std::cout << name << " robi 'hau-hau'.\n";
}

// Pocztek funkcji main().
int main() {

    // Utworzenie kota i psa.
    Cat cat("Garfield");
    Dog dog("Odie");
    
    // Utworzenie przyjaciela.
    PetRenamer petRenamer("Janek");
        
    // Zwierzta zajmuj si sob.
    cat.sleep();
    
    // Zmiana imieniu kota.
    petRenamer.rename(&cat, "Bonifacy");
    cat.eat();
    cat.climb();
        
    dog.sleep();
    dog.eat();
    
    // Zmiana imienia psa.
    petRenamer.rename(&dog, "Pluto");
    
    dog.bark();
        
    // Zakoczenie programu.
    std::cout << "Nacinij Enter lub Return, aby kontynuowa.";
    std::cin.get();
    return 0;
    
} // Koniec funkcji main().
