// quote.cpp - Listing 7.5

// Potrzebujemy pliku iostream, by mc
// korzysta z cout i cin.
#include <iostream>

// Potrzebujemy pliku string, aby
// operowa acuchami znakw.
#include <string>

// Potrzebujemy pliku fstream,
// aby mc pracowa z plikami.
#include <fstream>


// Deklaracja klasy.
class StoreQuote {

public:
    // Deklaracja atrybutw.
    std::string quote, speaker;

    // Definicja obiektu plikowego.
    std::ofstream fileOutput;

    // Konstruktor.
    StoreQuote();

    // Destruktor.
    ~StoreQuote();

    // Deklaracja metod.
    void inputQuote();
    void inputSpeaker();
    bool write();

}; // Nie zapominajmy o redniku!

// Definicja konstruktora.
// Konstruktor otwiera plik.
StoreQuote::StoreQuote() {
    fileOutput.open("cytaty.txt", std::ios::app);
}

// Definicja destruktora.
// Destruktor zamyka plik.
StoreQuote::~StoreQuote() {
    fileOutput.close();
}

// Definicja metod klasy Quote.
 
/* Metoda inputQuote przypisuje
 * cytat atrybutowi quote.
 * Nie pobiera argumentw.
 * Nie zwraca adnej wartoci.
 */
void StoreQuote::inputQuote() {
    std::getline(std::cin, quote);
}

/* Metoda inputSpeaker przypisuje
 * autora atrybutowi speaker.
 * Nie pobiera argumentw.
 * Nie zwraca adnej wartoci.
 */
void StoreQuote::inputSpeaker() {
    std::getline(std::cin, speaker);
}

/* Metoda write() zwraca warto
 * logiczn wskazujc, czy dane zostay
 * zapisane do pliku, czy te nie.
 * Nie pobiera argumentw.
 * Nie zwraca adnej wartoci.
 */
bool StoreQuote::write() {
   
    if (fileOutput.is_open()) {

        // Zapisz dane do pliku.
        fileOutput << quote << "|"
        << speaker << "\n";

        return true;
   
    } else {
        return false;
    }
}


// Pocztek funkcji main().
int main() {

    // Stwrz nowy obiekt.
    StoreQuote quote;

    // Zapytaj o cytat i wczytaj wejcie.
    std::cout << "Podaj cytat (bez cudzysowu):\n";
    quote.inputQuote();

    // Zapytaj o autora cytatu i wczytaj wejcie.
    std::cout << "Podaj osob, ktrej przypisuje si cytat:\n";
    quote.inputSpeaker();
   
    // Zapisz dane.
    if (quote.write()) {

        // Wywietl komunikat.
        std::cout << "Dane zostay zapisane do pliku!\n";

    } else { // Nie mona otworzy pliku.
        std::cout << "Dane nie mogy zosta zapisane!\n";
        return 1; // Wskazuje, e wystpi problem.
    }

    // Oczekiwanie, a uytkownik nacinie Enter lub Return.
    std::cout << "Nacinij Enter lub Return, aby kontynuowa.\n";
    std::cin.get();

    // Zwrcenie warto 0, by zaznaczy brak problemw.
    return 0;

} // Koniec funkcji main().
