// currency.cpp - Listing 5.3

// Potrzebujemy pliku iostream, by mc
// korzysta z cout i cin.
#include <iostream>

/* Prototyp pierwszej funkcji.
 * Funkcja nie pobiera argumentw.
 * Funkcja nie zwraca wartoci.
 */
void promptAndWait();

/* Prototyp drugiej funkcji.
 * Funkcja pobiera dwa argumenty:
 * jeden typu float i jeden typu unsigned int.
 * Argument typu unsigned int ma domyln warto 1.
 * Funkcja nie zwraca wartoci.
 */
void dollarsToEuros(float rate, unsigned dollars = 1);

// Pocztek funkcji main().
int main() {

    // Deklaracja zmiennych.
    float conversionRate = 0.832339; // $1 = 0.832339 Euro
    unsigned dollarsIn;
    
    // Wypisanie kursu walut przez wywoanie funkcji.
    dollarsToEuros(conversionRate);
    
    // Proba o podanie kwoty pienidzy i wczytanie jej.
    std::cout << "Podaj kwot pienidzy w dolarach (bez znaku dolara, przecinka ani kropki): [###] ";
    std::cin >> dollarsIn;
   
    // Wypisanie kwoty po zamianie walut.
    dollarsToEuros(conversionRate, dollarsIn);
    
    // Wywoanie funkcji promptAndWait().
    promptAndWait();
        
    // Zwrcenie wartoci 0, by zaznaczy brak problemw.
    return 0;
 
} // Koniec funkcji main().


// Definicja funkcji promptAndWait().
void promptAndWait() {
    std::cin.ignore(100, '\n');
    std::cout << "Nacinij Enter lub Return, aby kontynuowa.\n";
    std::cin.get();
} // Koniec funkcji promptAndWait().


// Definicja funkcji dollarsToEuros().
void dollarsToEuros(float rate, unsigned dollars) {

    // Ustawianie formatowania.
    std::cout.setf(std::ios_base::fixed);
    std::cout.setf(std::ios_base::showpoint);
    std::cout.precision(2);
    
    // Wypisanie wynikw.
    std::cout << "\n$" << dollars 
    << " US = " << (rate * dollars)
    << " Euro.\n\n";
    
} // Koniec funkcji dollarsToEuros().
