(ns examples.introduction)

; START:blank
(defn blank? [str]
  (every? #(Character/isWhitespace %) str))
; END:blank

(def accounts (ref #{}))
(defstruct account :id :balance)

; START:hello-world
(defn hello-world [username] 
  (println (format "Witaj, %s" username)))  
; END:hello-world

(def fibs (lazy-cat [0 1] (map + fibs (rest fibs))))

; START:hello-docstring
(defn hello
  "Wywietla powitanie na wyjciu. Pozdrawia, uywajc nazwy uytkownika."
  [username]
  (println (str "Witaj, " username)))
; END:hello-docstring
(def hello-docstring hello)

(def visitors (atom #{}))

; START:hello
(defn hello 
  "Wywietla powitanie na wyjciu. Pozdrawia, uywajc nazwy uytkownika.
  Uwzgldnia wczeniejsze wizyty."
  [username]
  (swap! visitors conj username)
  (str "Witaj, " username))
; END:hello

(def hello-with-memory hello)