(ns examples.test.interop
  (:use clojure.test)
  (:use examples.interop))

(deftest sum-to-variants
  (is (= (sum-to 10) 55))
  (is (= (integer-sum-to 10) 55))
  (is (= (unchecked-sum-to 10) 55))
  (is (= (better-sum-to 10) 55))
  (is (= (best-sum-to 10) 55))
)

(deftest test-painstakingly-create-array
  (is (= (seq (painstakingly-create-array))
	 ["Zapenianie" "tablic" "jest" "tu" "kopotliwe"])))

(deftest sax-parsing
  (is (= (with-out-str (demo-sax-parse "<foo><bar>witaj</bar></foo>" print-element-handler))
	 "Wykryto element: foo\nWykryto element: bar\n")))

;; Pomijanie testu funkcji demo-threads
;; Test ten wymagaby wielowtkowej wersji funkcji with-out-str

(deftest test-try-finally
  (is (= (with-out-str (is (thrown? Exception (demo-try-finally))))
	 "Trzeba wykona operacje porzdkujce\n"))
)

(deftest test-class-available
  (is (thrown? ClassNotFoundException (poor-class-available? "java.lang.MicrosoftRocks")))
  (is (= String (poor-class-available? "java.lang.String")))
  (is (false? (class-available? "java.lang.MicrosoftRocks")))
  (is (class-available? "java.lang.String"))
)
  
(deftest test-describe-class
  (is (= {:name "java.lang.String", :final true} (untyped-describe-class String)))
  (is (= {:name "java.lang.String", :final true} (typed-describe-class String)))
  (is (thrown? IllegalArgumentException (untyped-describe-class "foo")))
  (is (thrown? ClassCastException (typed-describe-class "foo")))
)
	 


  
