// Rysunek 26.1. ReadServerFile.java
// Odczyt pliku przez otwarcie połączenia na podstawie adresu URL
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class ReadServerFile extends JFrame 
{
   private JTextField enterField; // Kontrolka JTextField do wpisania adresu
   private JEditorPane contentsArea; // Kontrolka wyświetlająca zawartość strony

   // Konfiguracja interfejsu graficznego
   public ReadServerFile()
   {
      super("Prosta przeglądarka internetowa");

      // Utwórz pole tekstowe enterField i zarejestruj kod nasłuchujący zdarzeń
      enterField = new JTextField("Wpisz tu adres URL");
      enterField.addActionListener(
         new ActionListener() 
         {
            // Pobierz dokument wskazany przez użytkownika
            public void actionPerformed(ActionEvent event)
            {
               getThePage(event.getActionCommand());
            } 
         } 
      ); 

      add(enterField, BorderLayout.NORTH);

      contentsArea = new JEditorPane(); // Tworzenie contentsArea
      contentsArea.setEditable(false);
      contentsArea.addHyperlinkListener(
         new HyperlinkListener() 
         {
            // Jeśli użytkownik kliknie hiperłącze, przejdź do wskazanej strony
            public void hyperlinkUpdate(HyperlinkEvent event)
            {
               if (event.getEventType() == 
                    HyperlinkEvent.EventType.ACTIVATED)
                  getThePage(event.getURL().toString());
            } 
         } 
      ); 

      add(new JScrollPane(contentsArea), BorderLayout.CENTER);
      setSize(400, 300); // Ustaw rozmiar okna
      setVisible(true); // Pokaż okno
   }

   // Wczytaj dokument
   private void getThePage(String location)
   {
      try // Wczytaj dokument i wyświetl lokalizację
      {
         contentsArea.setPage(location); // Ustaw stronę
         enterField.setText(location); // Ustaw tekst
      } 
      catch (IOException ioException) 
      {
         JOptionPane.showMessageDialog(this,
            "Błąd pobierania wskazanego adresu URL", "Niepoprawny URL", 
            JOptionPane.ERROR_MESSAGE);
      } 
   }
} 


/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
