// Rysunek 23.19. CircularBufferTest.java
// Wątki Producer i Consumer poprawnie obsługują bufor cykliczny
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class CircularBufferTest {
   public static void main(String[] args) throws InterruptedException {
      // Utwórz nową pulę wątków
      ExecutorService executorService = Executors.newCachedThreadPool();

      // Utwórz CircularBuffer przechowujący wartości int       
      CircularBuffer sharedLocation = new CircularBuffer();

      // Wyświetl stan początkowy CircularBuffer
      sharedLocation.displayState("Stan początkowy");

      // Wykonanie zadań Producer i Consumer
      executorService.execute(new Producer(sharedLocation));
      executorService.execute(new Consumer(sharedLocation));

      executorService.shutdown();
      executorService.awaitTermination(1, TimeUnit.MINUTES); 
   }
}




/**************************************************************************
 * (C) Copyright 1992-2015 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/