// TransitionAnimationsController.java
// Stosowanie animacji Transition dla Rectangle
import javafx.animation.FadeTransition;
import javafx.animation.FillTransition;
import javafx.animation.Interpolator;
import javafx.animation.ParallelTransition;
import javafx.animation.PathTransition;
import javafx.animation.RotateTransition;
import javafx.animation.ScaleTransition;
import javafx.animation.SequentialTransition;
import javafx.animation.StrokeTransition;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.paint.Color;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;

public class TransitionAnimationsController {
   @FXML private Rectangle rectangle;
   
   // Konfiguracja i rozpoczęcie animacji przejść
   @FXML
   private void startButtonPressed(ActionEvent event) {
      // Przejście zmieniające wypełnienie kształtu
      FillTransition fillTransition = 
         new FillTransition(Duration.seconds(1));
      fillTransition.setToValue(Color.CYAN);
      fillTransition.setCycleCount(2);
      
      // Każdy cykl parzysty odtwarza przejście odwrotnie, aby przywrócić pierwotną wersję
      fillTransition.setAutoReverse(true); 

      // Przejście zmieniające obwódkę kształtu
      StrokeTransition strokeTransition = 
         new StrokeTransition(Duration.seconds(1));
      strokeTransition.setToValue(Color.BLUE);
      strokeTransition.setCycleCount(2);
      strokeTransition.setAutoReverse(true);
      
      // Zrównoleglenie dwóch przejść
      ParallelTransition parallelTransition = 
         new ParallelTransition(fillTransition, strokeTransition);

      // Zmiana przezroczystości w czasie
      FadeTransition fadeTransition = 
         new FadeTransition(Duration.seconds(1));
      fadeTransition.setFromValue(1.0); // Nieprzezroczysty
      fadeTransition.setToValue(0.0); // Przezroczysty
      fadeTransition.setCycleCount(2);
      fadeTransition.setAutoReverse(true);

      // Przejście obracające prostokąt
      RotateTransition rotateTransition = 
         new RotateTransition(Duration.seconds(1));
      rotateTransition.setByAngle(360.0);
      rotateTransition.setCycleCount(2);
      rotateTransition.setInterpolator(Interpolator.EASE_BOTH);
      rotateTransition.setAutoReverse(true);
      
      // Przejście przesuwające węzeł po ścieżce
      Path path = new Path(new MoveTo(45, 45), new LineTo(45, 0), 
         new LineTo(90, 0), new LineTo(90, 90), new LineTo(0, 90));
      PathTransition translateTransition = 
         new PathTransition(Duration.seconds(2), path);
      translateTransition.setCycleCount(2);
      translateTransition.setInterpolator(Interpolator.EASE_IN);
      translateTransition.setAutoReverse(true);
      
      // Przejście skalujące kształt do większego i mniejszego
      ScaleTransition scaleTransition =
         new ScaleTransition(Duration.seconds(1));
      scaleTransition.setByX(0.75);
      scaleTransition.setByY(0.75);
      scaleTransition.setCycleCount(2);
      scaleTransition.setInterpolator(Interpolator.EASE_OUT);
      scaleTransition.setAutoReverse(true);

      // Przejście stosujące serię przejść dla węzła
      SequentialTransition sequentialTransition = 
         new SequentialTransition (rectangle, parallelTransition, 
            fadeTransition, rotateTransition, translateTransition, 
            scaleTransition);
      sequentialTransition.play(); // Uruchomienie przejść
   }
}

/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
