// Rysunek 16.17. WordTypeCount.java
// Program zliczający wystąpienia poszczególnych wyrazów w przekazanym tekście
import java.util.Map;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import java.util.Scanner;

public class WordTypeCount {
   public static void main(String[] args) {
      // Utwórz HashMap, aby przechowywać klucze typu String i wartości typu Integer
      Map<String, Integer> myMap = new HashMap<>();            

      createMap(myMap); // Utwórz odwzorowanie na podstawie danych od użytkownika
      displayMap(myMap); // Wyświetl zawartość odwzorowania
   } 

   // Tworzy odwzorowanie na podstawie danych od użytkownika
   private static void createMap(Map<String, Integer> map) {
      Scanner scanner = new Scanner(System.in); // Utwórz obiekt Scanner
      System.out.println("Wpisz tekst:"); // Poproś o dane
      String input = scanner.nextLine();

      // Tokenizacja tekstu.
      String[] tokens = input.split(" ");
               
      // Przetwarzanie tekstu.
      for (String token : tokens) {
         String word = token.toLowerCase(); // Zamień na wyraz pisany małymi literami
                  
         // Jeśli odwzorowanie zawiera wyraz, zwiększ licznik
         if (map.containsKey(word)) { // Czy wyraz już istnieje?
            int count = map.get(word); // Pobierz aktualną wartość licznika
            map.put(word, count + 1); // Zwiększ licznik  
         } 
         else {
            map.put(word, 1); // Dodaj nowy wyraz z licznikiem równym 1
         } 
      } 
   } 
   
   // Wyświetla zawartość odwzorowania
   private static void displayMap(Map<String, Integer> map) {
      Set<String> keys = map.keySet(); // Pobierz klucze

      // Posortuj klucze
      TreeSet<String> sortedKeys = new TreeSet<>(keys);

      System.out.printf("%nOdwzorowanie zawiera:%nKlucz\t\tWartość%n");

      // Wygeneruj dane dla każdego klucza odwzorowania
      for (String key : sortedKeys) {
         System.out.printf("%-11s%10s%n", key, map.get(key));
      }
      
      System.out.printf(
         "%nsize: %d%nisEmpty: %b%n", map.size(), map.isEmpty());
   } 
} 


/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
