// Rysunek 16.16. SortedSetTest.java
// Zastosowanie interfejsu SortedSet i klasy TreeSet
import java.util.Arrays;
import java.util.SortedSet;
import java.util.TreeSet;

public class SortedSetTest {
   public static void main(String[] args) {
      // Utwórz obiekt TreeSet z tablicy colors
      String[] colors = {"żółty", "zielony", "czarny", "brązowy", "szary",
         "biały", "pomarańczowy", "czerwony", "zielony"};
      SortedSet<String> tree = new TreeSet<>(Arrays.asList(colors));

      System.out.print("Posortowany zbiór: ");
      printSet(tree); 

      // Pobierz headSet na podstawie "pomarańczowy"
      System.out.print("headSet (\"pomarańczowy\"):  ");
      printSet(tree.headSet("pomarańczowy"));

      // Pobierz tailSet na podstawie "pomarańczowy"
      System.out.print("tailSet (\"pomarańczowy\"):  ");
      printSet(tree.tailSet("pomarańczowy"));

      // Pobierz pierwszy i ostatni element
      System.out.printf("Pierwszy: %s%n", tree.first());
      System.out.printf("Ostatni : %s%n", tree.last());
   } 

   // Wyświetl SortedSet za pomocą rozszerzonej pętli for
   private static void printSet(SortedSet<String> set) {
      for (String s : set) {
         System.out.printf("%s ", s);
      }

      System.out.println();
   } 
} 

/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
