// Rysunek 16.12. BinarySearchTest.java
// Metoda binarySearch klasy Collections
import java.util.List;
import java.util.Arrays;
import java.util.Collections;
import java.util.ArrayList;

public class BinarySearchTest {
   public static void main(String[] args) {
      // Utwórz ArrayList<String> z zawartości tablicy colors
      String[] colors = {"czerwony", "biały", "niebieski", "czarny", "żółty", 
         "purpurowy", "brązowy", "różowy"};
      List<String> list = new ArrayList<>(Arrays.asList(colors));

      Collections.sort(list); // Posortuj ArrayList
      System.out.printf("Posortowana ArrayList: %s%n", list);

      // Poszukaj w liście różnych wartości.
      printSearchResults(list, "czarny"); 
      printSearchResults(list, "czerwony"); 
      printSearchResults(list, "różowy"); 
      printSearchResults(list, "amarantowy"); // Poniżej najniższego
      printSearchResults(list, "szary"); // Nie istnieje
      printSearchResults(list, "kawowy"); // Nie istnieje
   }      

   // Wykonaj wyszukiwanie i wyświetl wyniki
   private static void printSearchResults(
      List<String> list, String key) {

      System.out.printf("%nSzukam: %s%n", key);
      int result = Collections.binarySearch(list, key);
      
      if (result >= 0) {
         System.out.printf("Znaleziono pod indeksem %d%n", result);
      } 
      else {
         System.out.printf("Nie znaleziono (%d)%n", result);
      } 
   } 
}

/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
