// Rysunek 15.13. ReadSequentialFile.java
// Odczyt obiektów serializowanych do XML za pomocą JAXB
// i BufferedReader i ich wyświetlenie
import java.io.BufferedReader;      
import java.io.IOException;      
import java.nio.file.Files;
import java.nio.file.Paths;
import javax.xml.bind.JAXB;

public class ReadSequentialFile {
   public static void main(String[] args) {
      // Spróbuj otworzyć plik w celu deserializacji
      try(BufferedReader input = 
         Files.newBufferedReader(Paths.get("clients.xml"))) {
         // Zdekoduj zawartość pliku
         Accounts accounts = JAXB.unmarshal(input, Accounts.class);
         
         // Wyświetl zawartość
         System.out.printf("%-10s%-12s%-12s%10s%n", "Konto",
            "Imię", "Nazwisko", "Saldo");

         for (Account account : accounts.getAccounts()) {
            System.out.printf("%-10d%-12s%-12s%10.2f%n",  
               account.getAccountNumber(), account.getFirstName(), 
               account.getLastName(), account.getBalance());
         }
      } 
      catch (IOException ioException) {
         System.err.println("Błąd otwarcia pliku.");
      } 
   }
}


/*************************************************************************
* (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
* Pearson Education, Inc. All Rights Reserved.                           *
*                                                                        *
* DISCLAIMER: The authors and publisher of this book have used their     *
* best efforts in preparing the book. These efforts include the          *
* development, research, and testing of the theories and programs        *
* to determine their effectiveness. The authors and publisher make       *
* no warranty of any kind, expressed or implied, with regard to these    *
* programs or to the documentation contained in these books. The authors *
* and publisher shall not be liable in any event for incidental or       *
* consequential damages in connection with, or arising out of, the       *
* furnishing, performance, or use of these programs.                     *
*************************************************************************/