// Rysunek 13.7. PainterController.java
// Kontroler dla aplikacji Painter
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;

public class PainterController {
   // Typ enum reprezentujący rozmiary pędzla
   private enum PenSize {
      SMALL(2), 
      MEDIUM(4), 
      LARGE(6);
      
      private final int radius;
      
      PenSize(int radius) {this.radius = radius;}
      
      public int getRadius() {return radius;}
   };

   // Zmienne instancji odnoszące się do komponentów GUI
   @FXML private RadioButton blackRadioButton;
   @FXML private RadioButton redRadioButton;
   @FXML private RadioButton greenRadioButton;
   @FXML private RadioButton blueRadioButton;
   @FXML private RadioButton smallRadioButton;
   @FXML private RadioButton mediumRadioButton;
   @FXML private RadioButton largeRadioButton;
   @FXML private Pane drawingAreaPane;
   @FXML private ToggleGroup colorToggleGroup;
   @FXML private ToggleGroup sizeToggleGroup;

   // Zmienne instancji zarządzające stanem aplikacji
   private PenSize radius = PenSize.MEDIUM; // Promień koła
   private Paint brushColor = Color.BLACK; // Kolor rysowania
   
   // Ustaw dane użytkownika dla obiektów RadioButton
   public void initialize() {
      // Dane użytkownika w kontrolce mogą być dowolnym obiektem
      blackRadioButton.setUserData(Color.BLACK);
      redRadioButton.setUserData(Color.RED);
      greenRadioButton.setUserData(Color.GREEN);
      blueRadioButton.setUserData(Color.BLUE);
      smallRadioButton.setUserData(PenSize.SMALL);
      mediumRadioButton.setUserData(PenSize.MEDIUM);
      largeRadioButton.setUserData(PenSize.LARGE);      
   }
   
   // Obsługuje zdarzenie onMouseDragged typu MouseEvent z obszaru rysowania
   @FXML
   private void drawingAreaMouseDragged(MouseEvent e) {
      Circle newCircle = new Circle(e.getX(), e.getY(), 
         radius.getRadius(), brushColor);
      drawingAreaPane.getChildren().add(newCircle); 
   }
   
   // Obsługuje zdarzenia ActionEvent z obiektów RadioButton kolorów
   @FXML
   private void colorRadioButtonSelected(ActionEvent e) {
      // Dane użytkownika dla każdego RadioButton dotyczącego koloru zawierają obiekt Color
      brushColor = 
         (Color) colorToggleGroup.getSelectedToggle().getUserData();
   } 
      
   // Obsługuje zdarzenia ActionEvent z obiektów RadioButton rozmiaru
   @FXML
   private void sizeRadioButtonSelected(ActionEvent e) {
      // Dane użytkownika dla każdego RadioButton dotyczącego rozmiaru zawierają obiekt PenSize
      radius = 
         (PenSize) sizeToggleGroup.getSelectedToggle().getUserData();
   } 
      
   // Obsługuje zdarzenia ActionEvent przycisku cofnięcia
   @FXML
   private void undoButtonPressed(ActionEvent event) {
      int count = drawingAreaPane.getChildren().size();

      // Jeśli istnieją jakieś kształty, usuń ostatni
      if (count > 0) {
         drawingAreaPane.getChildren().remove(count - 1);
      }
   }
   
   // Obsługa zdarzenia ActionEvent przycisku czyszczenia
   @FXML
   private void clearButtonPressed(ActionEvent event) {
      drawingAreaPane.getChildren().clear(); // Czyści kanwę
   }
}


/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
