// Rysunek 11.5. UsingExceptions.java
// Mechanizm obsługi wyjątków try...catch...finally

public class UsingExceptions {
   public static void main(String[] args) {
      try {
         throwException(); 
      } 
      catch (Exception exception) { // Wyjątek zgłoszony przez throwException
         System.err.println("Wyjątek obsłużony w main.");
      } 

      doesNotThrowException();
   }

   // Przykład użycia try...catch...finally.
   public static void throwException() throws Exception {
      try { // Zgłasza wyjątek i od razu go wychwytuje
         System.out.println("Metoda throwException.");
         throw new Exception(); // Generuje wyjątek
      } 
      catch (Exception exception) { // Wychwytuje wyjątek zgłoszony w try
         System.err.println(
            "Obsługa wyjątku w metodzie throwException.");
         throw exception; // Ponowne zgłoszenie w celu dalszego przetwarzania

         // Kodu tutaj nie uda się osiągnąć; spowodowałby błąd kompilacji

      } 
      finally { // Wykona się niezależnie od tego, co się stanie w try...catch
         System.err.println("Blok finally wykonany w throwException.");  
      }                                                             

      // Kodu tutaj nie uda się osiągnąć; spowodowałby błąd kompilacji
   } 

   // Przykład finally, gdy nie ma wyjątku
   public static void doesNotThrowException() {
      try { // W bloku try wyjątek nie pojawi się
         System.out.println("Metoda doesNotThrowException.");
      } 
      catch (Exception exception) { // Nie wykona się
         System.err.println(exception);
      }
      finally { // Wykona się niezależnie od tego, co się stanie w try...catch     
         System.err.println("Blok finally wykonany w doesNotThrowException.");
      }                                                                  
 
      System.out.println("Koniec metody doesNotThrowException.");
   } 
} 

/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
