// Rysunek 10.14. PayableInterfaceTest.java
// Program testujący interfejs Payable umożliwia przetwarzanie obiektów
// Invoice i Employee w sposób polimorficzny.
public class PayableInterfaceTest {
   public static void main(String[] args) {
      // Utwórz czteroelementową tablicę obiektów Payable.
      Payable[] payableObjects = new Payable[] {
         new Invoice("01234", "siedzenie", 2, 375.00),
         new Invoice("56789", "opona", 4, 79.95),
         new SalariedEmployee("Anna", "Nowak", "111-11-1111", 800.00),
         new SalariedEmployee("Jan", "Kowalski", "888-88-8888", 1200.00)
      };

      System.out.println(
         "Obiekty Invoice i Employee przetwarzane polimorficznie:");

      // W ogólny sposób przetwórz każdy element tablicy payableObjects.
      for (Payable currentPayable : payableObjects) {
         // Wyświetl dane currentPayable i kwotę płatności.
         System.out.printf("%n%s %nkwota płatności: %,.2f zł%n", 
            currentPayable.toString(), // Można użyć wywołania niejawnego.
            currentPayable.getPaymentAmount()); 
      } 
   } 
} 


/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
