// Rysunek 9.6. BasePlusCommissionEmployee.java
// Klasa BasePlusCommissionEmployee class reprezentuje pracownika,
// który otrzymuje wynagrodzenie bazowe poza procentem od sprzedaży.
public class BasePlusCommissionEmployee {
   private final String firstName;
   private final String lastName;
   private final String socialSecurityNumber;
   private double grossSales; // Łączna tygodniowa sprzedaż.
   private double commissionRate; // Procent prowizji.
   private double baseSalary; // Tygodniowe wynagrodzenie bazowe.

   // Konstruktor sześcioargumentowy.
   public BasePlusCommissionEmployee(String firstName, String lastName, 
      String socialSecurityNumber, double grossSales, 
      double commissionRate, double baseSalary) {
      // Tutaj następuje niejawne wywołanie domyślnego konstruktora obiektu Object.

      // Jeśli łączna sprzedaż jest nieprawidłowa, zgłoś wyjątek.
      if (grossSales < 0.0) {
         throw new IllegalArgumentException("Łączna sprzedaż musi być >= 0.0");
      }     

      // Jeśli stawka prowizyjna jest nieprawidłowa, zgłoś wyjątek.
      if (commissionRate <= 0.0 || commissionRate >= 1.0) {
         throw new IllegalArgumentException(
            "Procent prowizji musi być > 0.0 i < 1.0");
      }     

      // Jeśli wynagrodzenie bazowe jest nieprawidłowe, zgłoś wyjątek.
      if (baseSalary < 0.0) {                                             
         throw new IllegalArgumentException("Wynagrodzenie bazowe musi być >= 0.0");
      }                                                                   

      this.firstName = firstName;
      this.lastName = lastName;
      this.socialSecurityNumber = socialSecurityNumber;
      this.grossSales = grossSales;
      this.commissionRate = commissionRate;
      this.baseSalary = baseSalary;
   } 

   // Zwróć imię.
   public String getFirstName() {return firstName;}

   // Zwróć nazwisko.
   public String getLastName() {return lastName;}

   // Zwróć numer ubezpieczenia.
   public String getSocialSecurityNumber() {return socialSecurityNumber;}

   // Ustaw łączną kwotę sprzedaży.
   public void setGrossSales(double grossSales) {
      if (grossSales < 0.0) {
         throw new IllegalArgumentException("Łączna sprzedaż musi być >= 0.0");
      }     

      this.grossSales = grossSales;
   } 

   // Zwróć  łączną kwotę sprzedaży.
   public double getGrossSales() {return grossSales;}

   // Ustaw łączną kwotę sprzedaży.
   public void setCommissionRate(double commissionRate) {
      if (commissionRate <= 0.0 || commissionRate >= 1.0) {
         throw new IllegalArgumentException(
            "Procent prowizji musi być w zakresie > 0.0 i < 1.0");
      }     

      this.commissionRate = commissionRate;
   } 

   // Zwróć procent prowizji.
   public double getCommissionRate() {return commissionRate;}

   // Ustaw wynagrodzenie bazowe.                         
   public void setBaseSalary(double baseSalary) {                         
      if (baseSalary < 0.0) {                                             
         throw new IllegalArgumentException("Wynagrodzenie bazowe musi być >= 0.0");
      }                                                                   
                                                                          
      this.baseSalary = baseSalary;                                       
   }                                                                      

   // Zwróć wynagrodzenie bazowe.
   public double getBaseSalary() {return baseSalary;}

   // Wylicz zarobek.
   public double earnings() {
      return baseSalary + (commissionRate * grossSales);
   } 

   // Zwróć tekstową reprezentację obiektu BasePlusCommissionEmployee.
   @Override
   public String toString() {
      return String.format(
         "%s: %s %s%n%s: %s%n%s: %.2f%n%s: %.2f%n%s: %.2f", 
         "pracownik prowizyjny z wynagrodzeniem bazowym", firstName, lastName,
         "numer ubezpieczenia", socialSecurityNumber,
         "łączna sprzedaż", grossSales, "procent prowizji", commissionRate, 
         "wynagrodzenie bazowe", baseSalary);
   }
} 


/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
